/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.service.notification;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.jolokia.server.core.http.BackChannel;
import org.jolokia.server.core.service.notification.ListenerRegistration;
import org.json.simple.JSONObject;

public class Client {
    private final String id;
    private final Map<String, BackChannel> backChannelMap;
    private final Map<String, ListenerRegistration> listenerConfigMap;
    private long lastRefresh;
    private final Set<String> usedBackends;
    private final AtomicLong handleSequence = new AtomicLong(0L);

    public Client(String pId) {
        this.id = pId;
        this.listenerConfigMap = new HashMap<String, ListenerRegistration>();
        this.backChannelMap = new HashMap<String, BackChannel>();
        this.usedBackends = new HashSet<String>();
        this.lastRefresh = System.currentTimeMillis();
    }

    public Set<String> getHandles() {
        return this.listenerConfigMap.keySet();
    }

    public void addNotification(String pHandle, ListenerRegistration pRegistration) {
        this.listenerConfigMap.put(pHandle, pRegistration);
    }

    public String getNextHandle() {
        return Long.toString(this.handleSequence.incrementAndGet());
    }

    public ListenerRegistration get(String pHandle) {
        ListenerRegistration config = this.listenerConfigMap.get(pHandle);
        if (config == null) {
            throw new IllegalArgumentException("No listener with handle " + pHandle + " created");
        }
        return config;
    }

    public void remove(String pHandle) {
        this.listenerConfigMap.remove(pHandle);
    }

    public void refresh() {
        this.lastRefresh = System.currentTimeMillis();
    }

    public JSONObject list() {
        JSONObject ret = new JSONObject();
        for (Map.Entry<String, ListenerRegistration> entry : this.listenerConfigMap.entrySet()) {
            ret.put((Object)entry.getKey(), (Object)entry.getValue().toJson());
        }
        return ret;
    }

    public long getLastRefresh() {
        return this.lastRefresh;
    }

    public String getId() {
        return this.id;
    }

    public BackChannel getBackChannel(String pMode) {
        return this.backChannelMap.get(pMode);
    }

    public void setBackChannel(String pMode, BackChannel pChannel) {
        this.backChannelMap.put(pMode, pChannel);
    }

    public void addUsedBackend(String pType) {
        this.usedBackends.add(pType);
    }

    Set<String> getUsedBackendModes() {
        return this.usedBackends;
    }
}

