/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple.ast;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.language.simple.ast.BaseSimpleNode;
import org.apache.camel.language.simple.ast.BlockStart;
import org.apache.camel.language.simple.ast.CompositeNodes;
import org.apache.camel.language.simple.ast.DoubleQuoteStart;
import org.apache.camel.language.simple.ast.LiteralNode;
import org.apache.camel.language.simple.ast.SimpleFunctionExpression;
import org.apache.camel.language.simple.ast.SimpleNode;
import org.apache.camel.language.simple.ast.SingleQuoteStart;
import org.apache.camel.language.simple.types.SimpleIllegalSyntaxException;
import org.apache.camel.language.simple.types.SimpleParserException;
import org.apache.camel.language.simple.types.SimpleToken;
import org.apache.camel.util.StringHelper;

public class SimpleFunctionStart
extends BaseSimpleNode
implements BlockStart {
    private final Map<String, Expression> cacheExpression;
    private final CompositeNodes block;

    public SimpleFunctionStart(SimpleToken token, Map<String, Expression> cacheExpression) {
        super(token);
        this.block = new CompositeNodes(token);
        this.cacheExpression = cacheExpression;
    }

    public CompositeNodes getBlock() {
        return this.block;
    }

    public boolean lazyEval(SimpleNode child) {
        String text = child.toString();
        return !text.startsWith("${type:");
    }

    @Override
    public String toString() {
        return "${" + String.valueOf(this.block) + "}";
    }

    @Override
    public Expression createExpression(CamelContext camelContext, String expression) {
        if (this.block.getChildren().size() == 1 && this.block.getChildren().get(0) instanceof LiteralNode) {
            return this.doCreateLiteralExpression(camelContext, expression);
        }
        return this.doCreateCompositeExpression(camelContext, expression);
    }

    private Expression doCreateLiteralExpression(CamelContext camelContext, String expression) {
        SimpleFunctionExpression function = new SimpleFunctionExpression(this.getToken(), this.cacheExpression);
        LiteralNode literal = (LiteralNode)this.block.getChildren().get(0);
        function.addText(literal.getText());
        return function.createExpression(camelContext, expression);
    }

    private Expression doCreateCompositeExpression(final CamelContext camelContext, final String expression) {
        final SimpleToken token = this.getToken();
        return new Expression(){

            public <T> T evaluate(Exchange exchange, Class<T> type) {
                StringBuilder sb = new StringBuilder();
                boolean quoteEmbeddedFunctions = false;
                for (SimpleNode child : SimpleFunctionStart.this.block.getChildren()) {
                    boolean lazy = true;
                    if (child instanceof SimpleFunctionStart) {
                        lazy = ((SimpleFunctionStart)child).lazyEval(child);
                    }
                    if (child instanceof LiteralNode) {
                        String text = ((LiteralNode)child).getText();
                        sb.append(text);
                        quoteEmbeddedFunctions |= ((LiteralNode)child).quoteEmbeddedNodes();
                        continue;
                    }
                    if (!lazy || child instanceof SingleQuoteStart || child instanceof DoubleQuoteStart) {
                        try {
                            Expression nested = child.createExpression(camelContext, null);
                            String text = (String)nested.evaluate(exchange, String.class);
                            if (text == null) continue;
                            if (quoteEmbeddedFunctions && !StringHelper.isQuoted((String)text)) {
                                sb.append("'").append(text).append("'");
                                continue;
                            }
                            sb.append(text);
                            continue;
                        }
                        catch (SimpleParserException e) {
                            throw new SimpleIllegalSyntaxException(expression, e.getIndex(), e.getMessage(), (Throwable)((Object)e));
                        }
                    }
                    if (!(child instanceof SimpleFunctionStart)) continue;
                    sb.append(child);
                }
                String exp = sb.toString();
                SimpleFunctionExpression function = new SimpleFunctionExpression(token, SimpleFunctionStart.this.cacheExpression);
                function.addText(exp);
                try {
                    return (T)function.createExpression(camelContext, exp).evaluate(exchange, type);
                }
                catch (SimpleParserException e) {
                    throw new SimpleIllegalSyntaxException(expression, e.getIndex(), e.getMessage(), (Throwable)((Object)e));
                }
            }

            public String toString() {
                return expression;
            }
        };
    }

    @Override
    public boolean acceptAndAddNode(SimpleNode node) {
        if (node instanceof LiteralNode || node instanceof SimpleFunctionStart || node instanceof SingleQuoteStart || node instanceof DoubleQuoteStart) {
            this.block.addChild(node);
            return true;
        }
        return false;
    }

    @Override
    public String createCode(String expression) throws SimpleParserException {
        String answer = this.block.getChildren().size() == 1 && this.block.getChildren().get(0) instanceof LiteralNode ? this.doCreateLiteralCode(expression) : this.doCreateCompositeCode(expression);
        return answer;
    }

    private String doCreateLiteralCode(String expression) {
        SimpleFunctionExpression function = new SimpleFunctionExpression(this.getToken(), this.cacheExpression);
        LiteralNode literal = (LiteralNode)this.block.getChildren().get(0);
        function.addText(literal.getText());
        return function.createCode(expression);
    }

    private String doCreateCompositeCode(String expression) {
        StringBuilder sb = new StringBuilder();
        boolean quoteEmbeddedFunctions = false;
        for (SimpleNode child : this.block.getChildren()) {
            String text;
            if (child instanceof LiteralNode) {
                text = ((LiteralNode)child).getText();
                sb.append(text);
                quoteEmbeddedFunctions |= ((LiteralNode)child).quoteEmbeddedNodes();
                continue;
            }
            if (child instanceof SingleQuoteStart || child instanceof DoubleQuoteStart) {
                try {
                    text = child.createCode(null);
                    if (text == null) continue;
                    if (quoteEmbeddedFunctions && !StringHelper.isQuoted((String)text)) {
                        sb.append("'").append(text).append("'");
                        continue;
                    }
                    sb.append(text);
                    continue;
                }
                catch (SimpleParserException e) {
                    throw new SimpleIllegalSyntaxException(expression, e.getIndex(), e.getMessage(), (Throwable)((Object)e));
                }
            }
            if (!(child instanceof SimpleFunctionStart)) continue;
            String inlined = child.createCode(expression);
            sb.append(inlined);
        }
        String exp = sb.toString();
        SimpleFunctionExpression function = new SimpleFunctionExpression(this.token, this.cacheExpression);
        function.addText(exp);
        try {
            return function.createCode(exp);
        }
        catch (SimpleParserException e) {
            throw new SimpleIllegalSyntaxException(expression, e.getIndex(), e.getMessage(), (Throwable)((Object)e));
        }
    }
}

