/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl;

import java.io.IOException;
import java.net.DatagramPacket;
import javax.jmdns.impl.DNSIncoming;
import javax.jmdns.impl.JmDNSImpl;
import javax.jmdns.impl.constants.DNSConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SocketListener
extends Thread {
    static Logger logger = LoggerFactory.getLogger(SocketListener.class);
    private final JmDNSImpl _jmDNSImpl;

    SocketListener(JmDNSImpl jmDNSImpl) {
        super("SocketListener(" + (jmDNSImpl != null ? jmDNSImpl.getName() : "") + ")");
        this.setDaemon(true);
        this._jmDNSImpl = jmDNSImpl;
    }

    private void sleepThread() {
        if (this._jmDNSImpl._threadSleepDurationMs > 0L) {
            try {
                Thread.sleep(this._jmDNSImpl._threadSleepDurationMs);
            }
            catch (InterruptedException e) {
                logger.warn(this.getName() + ".run() interrupted ", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public void run() {
        block10: {
            try {
                byte[] buf = new byte[8972];
                DatagramPacket packet = new DatagramPacket(buf, buf.length);
                while (!this._jmDNSImpl.isCanceling() && !this._jmDNSImpl.isCanceled()) {
                    this.sleepThread();
                    packet.setLength(buf.length);
                    this._jmDNSImpl.getSocket().receive(packet);
                    if (!(this._jmDNSImpl.isCanceling() || this._jmDNSImpl.isCanceled() || this._jmDNSImpl.isClosing() || this._jmDNSImpl.isClosed())) {
                        try {
                            if (this._jmDNSImpl.getLocalHost().shouldIgnorePacket(packet)) continue;
                            DNSIncoming msg = new DNSIncoming(packet);
                            if (msg.isValidResponseCode()) {
                                if (logger.isTraceEnabled()) {
                                    logger.trace("{}.run() JmDNS in:{}", (Object)this.getName(), (Object)msg.print(true));
                                }
                                if (msg.isQuery()) {
                                    if (packet.getPort() != DNSConstants.MDNS_PORT) {
                                        this._jmDNSImpl.handleQuery(msg, packet.getAddress(), packet.getPort());
                                    }
                                    this._jmDNSImpl.handleQuery(msg, this._jmDNSImpl.getGroup(), DNSConstants.MDNS_PORT);
                                    continue;
                                }
                                this._jmDNSImpl.handleResponse(msg);
                                continue;
                            }
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug("{}.run() JmDNS in message with error code: {}", (Object)this.getName(), (Object)msg.print(true));
                        }
                        catch (IOException e) {
                            logger.warn(this.getName() + ".run() exception ", (Throwable)e);
                        }
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                if (this._jmDNSImpl.isCanceling() || this._jmDNSImpl.isCanceled() || this._jmDNSImpl.isClosing() || this._jmDNSImpl.isClosed()) break block10;
                logger.warn(this.getName() + ".run() exception ", (Throwable)e);
                this._jmDNSImpl.recover();
            }
        }
        logger.trace("{}.run() exiting.", (Object)this.getName());
    }

    public JmDNSImpl getDns() {
        return this._jmDNSImpl;
    }
}

