/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.support;

import jakarta.jms.Connection;
import jakarta.jms.JMSException;
import jakarta.jms.JMSSecurityException;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.QueueBrowser;
import jakarta.jms.QueueRequestor;
import jakarta.jms.Session;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jms.IllegalStateException;
import org.springframework.jms.InvalidClientIDException;
import org.springframework.jms.InvalidDestinationException;
import org.springframework.jms.InvalidSelectorException;
import org.springframework.jms.JmsException;
import org.springframework.jms.JmsSecurityException;
import org.springframework.jms.MessageEOFException;
import org.springframework.jms.MessageFormatException;
import org.springframework.jms.MessageNotReadableException;
import org.springframework.jms.MessageNotWriteableException;
import org.springframework.jms.ResourceAllocationException;
import org.springframework.jms.TransactionInProgressException;
import org.springframework.jms.TransactionRolledBackException;
import org.springframework.jms.UncategorizedJmsException;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class JmsUtils {
    private static final Log logger = LogFactory.getLog(JmsUtils.class);

    public static void closeConnection(@Nullable Connection con) {
        JmsUtils.closeConnection(con, false);
    }

    public static void closeConnection(@Nullable Connection con, boolean stop) {
        block9: {
            if (con != null) {
                try {
                    if (stop) {
                        try {
                            con.stop();
                            break block9;
                        }
                        finally {
                            con.close();
                        }
                    }
                    con.close();
                }
                catch (jakarta.jms.IllegalStateException ex) {
                    logger.debug((Object)("Ignoring Connection state exception - assuming already closed: " + ex));
                }
                catch (JMSException ex) {
                    logger.debug((Object)"Could not close JMS Connection", (Throwable)ex);
                }
                catch (Throwable ex) {
                    logger.debug((Object)"Unexpected exception on closing JMS Connection", ex);
                }
            }
        }
    }

    public static void closeSession(@Nullable Session session) {
        if (session != null) {
            try {
                session.close();
            }
            catch (JMSException ex) {
                logger.trace((Object)"Could not close JMS Session", (Throwable)ex);
            }
            catch (Throwable ex) {
                logger.trace((Object)"Unexpected exception on closing JMS Session", ex);
            }
        }
    }

    public static void closeMessageProducer(@Nullable MessageProducer producer) {
        if (producer != null) {
            try {
                producer.close();
            }
            catch (JMSException ex) {
                logger.trace((Object)"Could not close JMS MessageProducer", (Throwable)ex);
            }
            catch (Throwable ex) {
                logger.trace((Object)"Unexpected exception on closing JMS MessageProducer", ex);
            }
        }
    }

    public static void closeMessageConsumer(@Nullable MessageConsumer consumer) {
        if (consumer != null) {
            boolean wasInterrupted = Thread.interrupted();
            try {
                consumer.close();
            }
            catch (JMSException ex) {
                logger.trace((Object)"Could not close JMS MessageConsumer", (Throwable)ex);
            }
            catch (Throwable ex) {
                logger.trace((Object)"Unexpected exception on closing JMS MessageConsumer", ex);
            }
            finally {
                if (wasInterrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    public static void closeQueueBrowser(@Nullable QueueBrowser browser) {
        if (browser != null) {
            try {
                browser.close();
            }
            catch (JMSException ex) {
                logger.trace((Object)"Could not close JMS QueueBrowser", (Throwable)ex);
            }
            catch (Throwable ex) {
                logger.trace((Object)"Unexpected exception on closing JMS QueueBrowser", ex);
            }
        }
    }

    public static void closeQueueRequestor(@Nullable QueueRequestor requestor) {
        if (requestor != null) {
            try {
                requestor.close();
            }
            catch (JMSException ex) {
                logger.trace((Object)"Could not close JMS QueueRequestor", (Throwable)ex);
            }
            catch (Throwable ex) {
                logger.trace((Object)"Unexpected exception on closing JMS QueueRequestor", ex);
            }
        }
    }

    public static void commitIfNecessary(Session session) throws JMSException {
        Assert.notNull((Object)session, "Session must not be null");
        try {
            session.commit();
        }
        catch (jakarta.jms.IllegalStateException | jakarta.jms.TransactionInProgressException jMSException) {
            // empty catch block
        }
    }

    public static void rollbackIfNecessary(Session session) throws JMSException {
        Assert.notNull((Object)session, "Session must not be null");
        try {
            session.rollback();
        }
        catch (jakarta.jms.IllegalStateException | jakarta.jms.TransactionInProgressException jMSException) {
            // empty catch block
        }
    }

    public static String buildExceptionMessage(JMSException ex) {
        Object message = ex.getMessage();
        Exception linkedEx = ex.getLinkedException();
        if (linkedEx != null) {
            if (message == null) {
                message = linkedEx.toString();
            } else {
                String linkedMessage = linkedEx.getMessage();
                if (linkedMessage != null && !((String)message).contains(linkedMessage)) {
                    message = (String)message + "; nested exception is " + linkedEx;
                }
            }
        }
        return message;
    }

    public static JmsException convertJmsAccessException(JMSException ex) {
        Assert.notNull((Object)ex, "JMSException must not be null");
        if (ex instanceof jakarta.jms.IllegalStateException) {
            jakarta.jms.IllegalStateException jakartaISE = (jakarta.jms.IllegalStateException)ex;
            return new IllegalStateException(jakartaISE);
        }
        if (ex instanceof jakarta.jms.InvalidClientIDException) {
            jakarta.jms.InvalidClientIDException jakartaICIDE = (jakarta.jms.InvalidClientIDException)ex;
            return new InvalidClientIDException(jakartaICIDE);
        }
        if (ex instanceof jakarta.jms.InvalidDestinationException) {
            jakarta.jms.InvalidDestinationException jakartaIDE = (jakarta.jms.InvalidDestinationException)ex;
            return new InvalidDestinationException(jakartaIDE);
        }
        if (ex instanceof jakarta.jms.InvalidSelectorException) {
            jakarta.jms.InvalidSelectorException jakartaISE = (jakarta.jms.InvalidSelectorException)ex;
            return new InvalidSelectorException(jakartaISE);
        }
        if (ex instanceof JMSSecurityException) {
            JMSSecurityException jakartaJMSSE = (JMSSecurityException)ex;
            return new JmsSecurityException(jakartaJMSSE);
        }
        if (ex instanceof jakarta.jms.MessageEOFException) {
            jakarta.jms.MessageEOFException jakartaMEOFE = (jakarta.jms.MessageEOFException)ex;
            return new MessageEOFException(jakartaMEOFE);
        }
        if (ex instanceof jakarta.jms.MessageFormatException) {
            jakarta.jms.MessageFormatException jakartaMFE = (jakarta.jms.MessageFormatException)ex;
            return new MessageFormatException(jakartaMFE);
        }
        if (ex instanceof jakarta.jms.MessageNotReadableException) {
            jakarta.jms.MessageNotReadableException jakartaMNRE = (jakarta.jms.MessageNotReadableException)ex;
            return new MessageNotReadableException(jakartaMNRE);
        }
        if (ex instanceof jakarta.jms.MessageNotWriteableException) {
            jakarta.jms.MessageNotWriteableException jakartaMNWE = (jakarta.jms.MessageNotWriteableException)ex;
            return new MessageNotWriteableException(jakartaMNWE);
        }
        if (ex instanceof jakarta.jms.ResourceAllocationException) {
            jakarta.jms.ResourceAllocationException jakartaRAE = (jakarta.jms.ResourceAllocationException)ex;
            return new ResourceAllocationException(jakartaRAE);
        }
        if (ex instanceof jakarta.jms.TransactionInProgressException) {
            jakarta.jms.TransactionInProgressException jakartaTIPE = (jakarta.jms.TransactionInProgressException)ex;
            return new TransactionInProgressException(jakartaTIPE);
        }
        if (ex instanceof jakarta.jms.TransactionRolledBackException) {
            jakarta.jms.TransactionRolledBackException jakartaTRBE = (jakarta.jms.TransactionRolledBackException)ex;
            return new TransactionRolledBackException(jakartaTRBE);
        }
        return new UncategorizedJmsException(ex);
    }
}

