/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.language;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.model.PropertyDefinition;
import org.apache.camel.model.language.SingleInputTypedExpressionDefinition;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.NamespaceAware;
import org.apache.camel.support.builder.Namespaces;

@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class NamespaceAwareExpression
extends SingleInputTypedExpressionDefinition
implements NamespaceAware {
    @XmlElement(name="namespace")
    @Metadata(label="common")
    private List<PropertyDefinition> namespace;
    @XmlTransient
    private Map<String, String> namespaces;

    protected NamespaceAwareExpression() {
    }

    protected NamespaceAwareExpression(String expression) {
        super(expression);
    }

    protected NamespaceAwareExpression(AbstractNamespaceAwareBuilder<?, ?> builder) {
        super((SingleInputTypedExpressionDefinition.AbstractBuilder<?, ?>)builder);
        this.namespace = builder.namespace;
        this.namespaces = builder.namespaces;
    }

    public Map<String, String> getNamespaces() {
        return this.getNamespaceAsMap();
    }

    public void setNamespaces(Map<String, String> namespaces) {
        this.namespaces = namespaces;
    }

    public List<PropertyDefinition> getNamespace() {
        return this.namespace;
    }

    public void setNamespace(List<PropertyDefinition> namespace) {
        this.namespace = namespace;
    }

    public Map<String, String> getNamespaceAsMap() {
        if (this.namespaces == null && this.namespace != null) {
            this.namespaces = new HashMap<String, String>();
        }
        if (this.namespace != null) {
            for (PropertyDefinition def : this.namespace) {
                this.namespaces.put(def.getKey(), def.getValue());
            }
        }
        return this.namespaces;
    }

    @XmlTransient
    static abstract class AbstractNamespaceAwareBuilder<T extends AbstractNamespaceAwareBuilder<T, E>, E extends NamespaceAwareExpression>
    extends SingleInputTypedExpressionDefinition.AbstractBuilder<T, E> {
        private List<PropertyDefinition> namespace;
        private Map<String, String> namespaces;

        AbstractNamespaceAwareBuilder() {
        }

        public T namespaces(Namespaces namespaces) {
            this.namespaces = namespaces.getNamespaces();
            return (T)this;
        }

        public T namespaces(Map<String, String> namespaces) {
            this.namespaces = namespaces;
            return (T)this;
        }

        public T namespace(List<PropertyDefinition> namespace) {
            this.namespace = namespace;
            return (T)this;
        }
    }
}

