/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.language;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.camel.model.language.TypedExpressionDefinition;
import org.apache.camel.spi.Metadata;
import org.apache.camel.util.StringHelper;

@Metadata(firstVersion="1.3.0", label="language,core,java", title="Bean Method")
@XmlRootElement(name="method")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class MethodCallExpression
extends TypedExpressionDefinition {
    @XmlTransient
    private Class<?> beanType;
    @XmlTransient
    private Object instance;
    @XmlAttribute
    private String ref;
    @XmlAttribute
    private String method;
    @XmlAttribute(name="beanType")
    private String beanTypeName;
    @XmlAttribute
    @Metadata(label="advanced", defaultValue="Singleton", enums="Singleton,Request,Prototype")
    private String scope;
    @XmlAttribute
    @Metadata(label="advanced", defaultValue="true", javaType="java.lang.Boolean")
    private String validate;

    public MethodCallExpression() {
    }

    public MethodCallExpression(String beanName) {
        this(beanName, null);
    }

    public MethodCallExpression(String beanName, String method) {
        super("");
        if (beanName != null && beanName.startsWith("ref:")) {
            beanName = beanName.substring(4);
        } else if (beanName != null && beanName.startsWith("bean:")) {
            beanName = beanName.substring(5);
        }
        this.setRef(beanName);
        this.setMethod(method);
    }

    public MethodCallExpression(Object instance) {
        this(instance, null);
    }

    public MethodCallExpression(Object instance, String method) {
        super("");
        this.setInstance(instance);
        this.setMethod(method);
    }

    public MethodCallExpression(Class<?> type) {
        this(type, null);
    }

    public MethodCallExpression(Class<?> type, String method) {
        super("");
        this.setBeanType(type);
        this.setBeanTypeName(type.getName());
        this.setMethod(method);
    }

    private MethodCallExpression(Builder builder) {
        super(builder);
        this.beanType = builder.beanType;
        this.instance = builder.instance;
        this.ref = builder.ref;
        this.method = builder.method;
        this.beanTypeName = builder.beanTypeName;
        this.scope = builder.scope;
        this.validate = builder.validate;
    }

    @Override
    public String getLanguage() {
        return "bean";
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public Class<?> getBeanType() {
        return this.beanType;
    }

    public void setBeanType(Class<?> beanType) {
        this.beanType = beanType;
        this.instance = null;
    }

    public String getBeanTypeName() {
        return this.beanTypeName;
    }

    public void setBeanTypeName(String beanTypeName) {
        this.beanTypeName = beanTypeName;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getValidate() {
        return this.validate;
    }

    public void setValidate(String validate) {
        this.validate = validate;
    }

    public Object getInstance() {
        return this.instance;
    }

    public void setInstance(Object instance) {
        if (instance instanceof Class) {
            this.beanType = (Class)instance;
            this.instance = null;
        } else {
            this.beanType = null;
            this.instance = instance;
        }
    }

    @Override
    public String toString() {
        Object name = this.ref != null ? "ref:" + this.ref : (this.beanTypeName != null ? StringHelper.afterLast((String)this.beanTypeName, (String)".", (String)this.beanTypeName) : (this.beanType != null ? this.beanType.getSimpleName() : (this.instance != null ? this.instance.getClass().getSimpleName() : this.getExpression())));
        return "bean[" + (String)name + (String)(this.method != null ? " method:" + this.method : "") + "]";
    }

    @XmlTransient
    public static class Builder
    extends TypedExpressionDefinition.AbstractBuilder<Builder, MethodCallExpression> {
        private Class<?> beanType;
        private Object instance;
        private String ref;
        private String method;
        private String beanTypeName;
        private String scope;
        private String validate;

        public Builder method(String method) {
            this.method = method;
            return this;
        }

        public Builder ref(String ref) {
            this.ref = ref;
            return this;
        }

        public Builder instance(Object instance) {
            if (instance instanceof Class) {
                this.beanType = (Class)instance;
                this.instance = null;
            } else {
                this.beanType = null;
                this.instance = instance;
            }
            return this;
        }

        public Builder beanType(Class<?> beanType) {
            this.beanType = beanType;
            this.instance = null;
            return this;
        }

        public Builder beanTypeName(String beanTypeName) {
            this.beanTypeName = beanTypeName;
            return this;
        }

        public Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        public Builder validate(String validate) {
            this.validate = validate;
            return this;
        }

        public Builder validate(boolean validate) {
            this.validate = Boolean.toString(validate);
            return this;
        }

        @Override
        public MethodCallExpression end() {
            return new MethodCallExpression(this);
        }
    }
}

