/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.errorhandler;

import org.apache.camel.CamelContext;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Route;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.errorhandler.RefErrorHandlerDefinition;
import org.apache.camel.support.CamelContextHelper;

public final class ErrorHandlerHelper {
    public static final String DEFAULT_ERROR_HANDLER_BUILDER = "CamelDefaultErrorHandlerBuilder";

    private ErrorHandlerHelper() {
    }

    public static ErrorHandlerFactory lookupErrorHandlerFactory(Route route, String ref, boolean mandatory) {
        ErrorHandlerFactory answer = null;
        CamelContext camelContext = route.getCamelContext();
        if (!ErrorHandlerHelper.isErrorHandlerFactoryConfigured(ref)) {
            ErrorHandlerFactory source = route.getErrorHandlerFactory();
            if (source instanceof RefErrorHandlerDefinition) {
                RefErrorHandlerDefinition other = (RefErrorHandlerDefinition)source;
                String otherRef = other.getRef();
                if (!ErrorHandlerHelper.isErrorHandlerFactoryConfigured(otherRef)) {
                    answer = ErrorHandlerHelper.lookupErrorHandlerFactory(camelContext);
                }
                if (answer == null) {
                    answer = ((ModelCamelContext)camelContext).getModelReifierFactory().createDefaultErrorHandler();
                }
                route.addErrorHandlerFactoryReference(source, answer);
            }
        } else {
            answer = mandatory ? (ErrorHandlerFactory)CamelContextHelper.mandatoryLookup((CamelContext)camelContext, (String)ref, ErrorHandlerFactory.class) : (ErrorHandlerFactory)CamelContextHelper.lookup((CamelContext)camelContext, (String)ref, ErrorHandlerFactory.class);
        }
        return answer;
    }

    protected static ErrorHandlerFactory lookupErrorHandlerFactory(CamelContext camelContext) {
        RefErrorHandlerDefinition other;
        String otherRef;
        ErrorHandlerFactory answer = camelContext.getCamelContextExtension().getErrorHandlerFactory();
        if (answer instanceof RefErrorHandlerDefinition && ErrorHandlerHelper.isErrorHandlerFactoryConfigured(otherRef = (other = (RefErrorHandlerDefinition)answer).getRef()) && (answer = (ErrorHandlerFactory)CamelContextHelper.lookup((CamelContext)camelContext, (String)otherRef, ErrorHandlerFactory.class)) == null) {
            throw new IllegalArgumentException("ErrorHandlerBuilder with id " + otherRef + " not found in registry.");
        }
        return answer;
    }

    public static boolean isErrorHandlerFactoryConfigured(String ref) {
        return !DEFAULT_ERROR_HANDLER_BUILDER.equals(ref);
    }
}

