/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.camel.builder.DataFormatBuilder;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(firstVersion="2.20.0", label="dataformat,transformation,file", title="ASN.1 File")
@XmlRootElement(name="asn1")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ASN1DataFormat
extends DataFormatDefinition {
    @XmlTransient
    private Class<?> unmarshalType;
    @XmlAttribute(name="unmarshalType")
    private String unmarshalTypeName;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String usingIterator;

    public ASN1DataFormat() {
        super("asn1");
    }

    public ASN1DataFormat(Boolean usingIterator) {
        this();
        this.setUsingIterator(usingIterator != null ? usingIterator.toString() : null);
    }

    public ASN1DataFormat(String unmarshalTypeName) {
        this();
        this.setUsingIterator(Boolean.toString(true));
        this.setUnmarshalTypeName(unmarshalTypeName);
    }

    public ASN1DataFormat(Class<?> unmarshalType) {
        this();
        this.setUsingIterator(Boolean.toString(true));
        this.unmarshalType = unmarshalType;
    }

    private ASN1DataFormat(Builder builder) {
        this();
        this.usingIterator = builder.usingIterator;
        this.unmarshalTypeName = builder.unmarshalTypeName;
        this.unmarshalType = builder.unmarshalType;
    }

    public String getUsingIterator() {
        return this.usingIterator;
    }

    public void setUsingIterator(String usingIterator) {
        this.usingIterator = usingIterator;
    }

    public String getUnmarshalTypeName() {
        return this.unmarshalTypeName;
    }

    public void setUnmarshalTypeName(String unmarshalTypeName) {
        this.unmarshalTypeName = unmarshalTypeName;
    }

    public Class<?> getUnmarshalType() {
        return this.unmarshalType;
    }

    public void setUnmarshalType(Class<?> unmarshalType) {
        this.unmarshalType = unmarshalType;
    }

    @XmlTransient
    public static class Builder
    implements DataFormatBuilder<ASN1DataFormat> {
        private Class<?> unmarshalType;
        private String unmarshalTypeName;
        private String usingIterator;

        public Builder usingIterator(String usingIterator) {
            this.usingIterator = usingIterator;
            return this;
        }

        public Builder usingIterator(boolean usingIterator) {
            this.usingIterator = Boolean.toString(usingIterator);
            return this;
        }

        public Builder unmarshalTypeName(String unmarshalTypeName) {
            this.unmarshalTypeName = unmarshalTypeName;
            return this;
        }

        public Builder unmarshalType(Class<?> unmarshalType) {
            this.unmarshalType = unmarshalType;
            return this;
        }

        @Override
        public ASN1DataFormat end() {
            return new ASN1DataFormat(this);
        }
    }
}

