/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.language;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.camel.model.language.SingleInputTypedExpressionDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(firstVersion="2.0.0", label="language,core", title="Tokenize")
@XmlRootElement(name="tokenize")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class TokenizerExpression
extends SingleInputTypedExpressionDefinition {
    @XmlAttribute(required=true)
    private String token;
    @XmlAttribute
    private String endToken;
    @XmlAttribute
    @Metadata(label="advanced")
    private String inheritNamespaceTagName;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String regex;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String xml;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String includeTokens;
    @XmlAttribute
    @Metadata(label="advanced")
    private String group;
    @XmlAttribute
    @Metadata(label="advanced")
    private String groupDelimiter;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String skipFirst;

    public TokenizerExpression() {
    }

    public TokenizerExpression(String token) {
        this.token = token;
    }

    private TokenizerExpression(Builder builder) {
        super(builder);
        this.token = builder.token;
        this.endToken = builder.endToken;
        this.inheritNamespaceTagName = builder.inheritNamespaceTagName;
        this.regex = builder.regex;
        this.xml = builder.xml;
        this.includeTokens = builder.includeTokens;
        this.group = builder.group;
        this.groupDelimiter = builder.groupDelimiter;
        this.skipFirst = builder.skipFirst;
    }

    @Override
    public String getLanguage() {
        return "tokenize";
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getEndToken() {
        return this.endToken;
    }

    public void setEndToken(String endToken) {
        this.endToken = endToken;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    public String getRegex() {
        return this.regex;
    }

    public String getInheritNamespaceTagName() {
        return this.inheritNamespaceTagName;
    }

    public void setInheritNamespaceTagName(String inheritNamespaceTagName) {
        this.inheritNamespaceTagName = inheritNamespaceTagName;
    }

    public String getXml() {
        return this.xml;
    }

    public void setXml(String xml) {
        this.xml = xml;
    }

    public String getIncludeTokens() {
        return this.includeTokens;
    }

    public void setIncludeTokens(String includeTokens) {
        this.includeTokens = includeTokens;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getGroupDelimiter() {
        return this.groupDelimiter;
    }

    public void setGroupDelimiter(String groupDelimiter) {
        this.groupDelimiter = groupDelimiter;
    }

    public String getSkipFirst() {
        return this.skipFirst;
    }

    public void setSkipFirst(String skipFirst) {
        this.skipFirst = skipFirst;
    }

    @Override
    public String toString() {
        if (this.endToken != null) {
            return "tokenize{body() using tokens: " + this.token + "..." + this.endToken + "}";
        }
        String s = this.getSource();
        if (s == null) {
            s = "body";
        }
        return "tokenize{" + s + " using token: " + this.token + "}";
    }

    @XmlTransient
    public static class Builder
    extends SingleInputTypedExpressionDefinition.AbstractBuilder<Builder, TokenizerExpression> {
        private String token;
        private String endToken;
        private String inheritNamespaceTagName;
        private String regex;
        private String xml;
        private String includeTokens;
        private String group;
        private String groupDelimiter;
        private String skipFirst;

        public Builder token(String token) {
            this.token = token;
            return this;
        }

        public Builder endToken(String endToken) {
            this.endToken = endToken;
            return this;
        }

        public Builder inheritNamespaceTagName(String inheritNamespaceTagName) {
            this.inheritNamespaceTagName = inheritNamespaceTagName;
            return this;
        }

        public Builder regex(String regex) {
            this.regex = regex;
            return this;
        }

        public Builder regex(boolean regex) {
            this.regex = Boolean.toString(regex);
            return this;
        }

        public Builder xml(String xml) {
            this.xml = xml;
            return this;
        }

        public Builder xml(boolean xml) {
            this.xml = Boolean.toString(xml);
            return this;
        }

        public Builder includeTokens(String includeTokens) {
            this.includeTokens = includeTokens;
            return this;
        }

        public Builder includeTokens(boolean includeTokens) {
            this.includeTokens = Boolean.toString(includeTokens);
            return this;
        }

        public Builder group(String group) {
            this.group = group;
            return this;
        }

        public Builder group(int group) {
            this.group = Integer.toString(group);
            return this;
        }

        public Builder groupDelimiter(String groupDelimiter) {
            this.groupDelimiter = groupDelimiter;
            return this;
        }

        public Builder skipFirst(String skipFirst) {
            this.skipFirst = skipFirst;
            return this;
        }

        public Builder skipFirst(boolean skipFirst) {
            this.skipFirst = Boolean.toString(skipFirst);
            return this;
        }

        @Override
        public TokenizerExpression end() {
            return new TokenizerExpression(this);
        }
    }
}

