/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.saga;

import java.util.concurrent.CompletableFuture;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Traceable;
import org.apache.camel.processor.saga.SagaCompletionMode;
import org.apache.camel.saga.CamelSagaCoordinator;
import org.apache.camel.saga.CamelSagaService;
import org.apache.camel.saga.CamelSagaStep;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.processor.DelegateAsyncProcessor;
import org.apache.camel.util.ObjectHelper;

public abstract class SagaProcessor
extends DelegateAsyncProcessor
implements Traceable,
IdAware,
RouteIdAware {
    protected final CamelSagaService sagaService;
    protected final CamelSagaStep step;
    protected final SagaCompletionMode completionMode;
    private String id;
    private String routeId;

    public SagaProcessor(CamelContext camelContext, Processor childProcessor, CamelSagaService sagaService, SagaCompletionMode completionMode, CamelSagaStep step) {
        super((Processor)ObjectHelper.notNull((Object)childProcessor, (String)"childProcessor"));
        this.sagaService = (CamelSagaService)ObjectHelper.notNull((Object)sagaService, (String)"sagaService");
        this.completionMode = (SagaCompletionMode)((Object)ObjectHelper.notNull((Object)((Object)completionMode), (String)"completionMode"));
        this.step = (CamelSagaStep)ObjectHelper.notNull((Object)step, (String)"step");
    }

    protected CompletableFuture<CamelSagaCoordinator> getCurrentSagaCoordinator(Exchange exchange) {
        String currentSaga = (String)exchange.getIn().getHeader("Long-Running-Action", String.class);
        if (currentSaga != null) {
            return this.sagaService.getSaga(currentSaga);
        }
        return CompletableFuture.completedFuture(null);
    }

    protected void setCurrentSagaCoordinator(Exchange exchange, CamelSagaCoordinator coordinator) {
        if (coordinator != null) {
            exchange.getIn().setHeader("Long-Running-Action", (Object)coordinator.getId());
        } else {
            exchange.getIn().removeHeader("Long-Running-Action");
            exchange.getMessage().removeHeader("Long-Running-Action");
        }
    }

    protected void handleSagaCompletion(Exchange exchange, CamelSagaCoordinator coordinator, CamelSagaCoordinator previousCoordinator, AsyncCallback callback) {
        if (this.completionMode == SagaCompletionMode.AUTO) {
            if (exchange.getException() != null) {
                if (coordinator != null) {
                    coordinator.compensate(exchange).whenComplete((done, ex) -> this.ifNotException((Throwable)ex, exchange, callback, () -> {
                        this.setCurrentSagaCoordinator(exchange, previousCoordinator);
                        callback.done(false);
                    }));
                } else {
                    callback.done(false);
                }
            } else {
                coordinator.complete(exchange).whenComplete((done, ex) -> this.ifNotException((Throwable)ex, exchange, callback, () -> {
                    this.setCurrentSagaCoordinator(exchange, previousCoordinator);
                    callback.done(false);
                }));
            }
        } else if (this.completionMode == SagaCompletionMode.MANUAL) {
            callback.done(false);
        } else {
            throw new IllegalStateException("Unsupported completion mode: " + this.completionMode);
        }
    }

    public CamelSagaService getSagaService() {
        return this.sagaService;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public String toString() {
        return "id";
    }

    public String getTraceLabel() {
        return "saga";
    }

    protected void ifNotException(Throwable ex, Exchange exchange, AsyncCallback callback, Runnable code) {
        this.ifNotException(ex, exchange, false, null, null, callback, code);
    }

    protected void ifNotException(Throwable ex, Exchange exchange, boolean handleCompletion, CamelSagaCoordinator coordinator, CamelSagaCoordinator previousCoordinator, AsyncCallback callback, Runnable code) {
        if (ex != null) {
            exchange.setException(ex);
            if (handleCompletion) {
                this.handleSagaCompletion(exchange, coordinator, previousCoordinator, callback);
            } else {
                callback.done(false);
            }
        } else {
            code.run();
        }
    }
}

