/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Traceable;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.util.ObjectHelper;

public class ScriptProcessor
extends AsyncProcessorSupport
implements Traceable,
IdAware,
RouteIdAware {
    private String id;
    private String routeId;
    private final Expression expression;

    public ScriptProcessor(Expression expression) {
        ObjectHelper.notNull((Object)expression, (String)"expression", (Object)((Object)this));
        this.expression = expression;
    }

    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            this.expression.evaluate(exchange, Object.class);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        callback.done(true);
        return true;
    }

    public String toString() {
        return this.id;
    }

    public String getTraceLabel() {
        return "script[" + this.expression + "]";
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRouteId() {
        return this.routeId;
    }

    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public Expression getExpression() {
        return this.expression;
    }
}

