/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker;

import java.net.URI;
import java.util.HashMap;
import org.apache.activemq.broker.BrokerFactoryHandler;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.util.IntrospectionSupport;
import org.apache.activemq.util.URISupport;

public class DefaultBrokerFactory
implements BrokerFactoryHandler {
    @Override
    public BrokerService createBroker(URI brokerURI) throws Exception {
        URISupport.CompositeData compositeData = URISupport.parseComposite(brokerURI);
        HashMap<String, String> params = new HashMap<String, String>(compositeData.getParameters());
        BrokerService brokerService = new BrokerService();
        IntrospectionSupport.setProperties(brokerService, params);
        if (!params.isEmpty()) {
            String msg = "There are " + params.size() + " Broker options that couldn't be set on the BrokerService. Check the options are spelled correctly. Unknown parameters=[" + params + "]. This BrokerService cannot be started.";
            throw new IllegalArgumentException(msg);
        }
        if (compositeData.getPath() != null) {
            brokerService.setBrokerName(compositeData.getPath());
        }
        URI[] components = compositeData.getComponents();
        for (int i2 = 0; i2 < components.length; ++i2) {
            if ("network".equals(components[i2].getScheme())) {
                brokerService.addNetworkConnector(components[i2].getSchemeSpecificPart());
                continue;
            }
            if ("proxy".equals(components[i2].getScheme())) {
                brokerService.addProxyConnector(components[i2].getSchemeSpecificPart());
                continue;
            }
            brokerService.addConnector(components[i2]);
        }
        return brokerService;
    }
}

