/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.partition;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.partition.PartitionBroker;
import org.apache.activemq.partition.ZKClient;
import org.apache.activemq.partition.ZooKeeperPartitionBrokerPlugin;
import org.apache.activemq.partition.dto.Partitioning;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;
import org.linkedin.util.clock.Timespan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperPartitionBroker
extends PartitionBroker {
    protected static final Logger LOG = LoggerFactory.getLogger(ZooKeeperPartitionBroker.class);
    protected volatile ZKClient zk_client = null;
    protected volatile Partitioning config;
    protected final CountDownLatch configAcquired = new CountDownLatch(1);

    public ZooKeeperPartitionBroker(Broker broker, ZooKeeperPartitionBrokerPlugin plugin) {
        super(broker, plugin);
    }

    @Override
    public void start() throws Exception {
        super.start();
        this.configAcquired.await(5L, TimeUnit.SECONDS);
    }

    @Override
    protected void onMonitorStop() {
        this.zkDisconnect();
    }

    @Override
    protected Partitioning getConfig() {
        return this.config;
    }

    protected ZooKeeperPartitionBrokerPlugin plugin() {
        return (ZooKeeperPartitionBrokerPlugin)this.plugin;
    }

    protected void zkConnect() throws Exception {
        this.zk_client = new ZKClient(this.plugin().getZkAddress(), Timespan.parse((String)this.plugin().getZkSessionTmeout()), null);
        if (this.plugin().getZkPassword() != null) {
            this.zk_client.setPassword(this.plugin().getZkPassword());
        }
        this.zk_client.start();
        this.zk_client.waitForConnected(Timespan.parse((String)"30s"));
    }

    protected void zkDisconnect() {
        if (this.zk_client != null) {
            this.zk_client.close();
            this.zk_client = null;
        }
    }

    @Override
    protected void reloadConfiguration() throws Exception {
        if (this.zk_client == null) {
            LOG.debug("Connecting to ZooKeeper");
            try {
                this.zkConnect();
                LOG.debug("Connected to ZooKeeper");
            }
            catch (Exception e) {
                LOG.debug("Connection to ZooKeeper failed: " + e);
                this.zkDisconnect();
                throw e;
            }
        }
        byte[] data = null;
        try {
            Stat stat = new Stat();
            data = this.zk_client.getData(this.plugin().getZkPath(), new Watcher(){

                public void process(WatchedEvent watchedEvent) {
                    try {
                        ZooKeeperPartitionBroker.this.reloadConfiguration();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ZooKeeperPartitionBroker.this.monitorWakeup();
                }
            }, stat);
            this.configAcquired.countDown();
            this.reloadConfigOnPoll = false;
        }
        catch (Exception e) {
            LOG.warn("Could load partitioning configuration: " + e, (Throwable)e);
            this.reloadConfigOnPoll = true;
        }
        try {
            this.config = (Partitioning)Partitioning.MAPPER.readValue(data, Partitioning.class);
        }
        catch (Exception e) {
            LOG.warn("Invalid partitioning configuration: " + e, (Throwable)e);
        }
    }
}

