/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.jms.pool;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import javax.net.ssl.SSLServerSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IntrospectionSupport {
    private static final Logger LOG = LoggerFactory.getLogger(IntrospectionSupport.class);

    private IntrospectionSupport() {
    }

    public static boolean setProperties(Object target, Map props) {
        boolean rc = false;
        if (target == null) {
            throw new IllegalArgumentException("target was null.");
        }
        if (props == null) {
            throw new IllegalArgumentException("props was null.");
        }
        Iterator iter = props.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (!IntrospectionSupport.setProperty(target, (String)entry.getKey(), entry.getValue())) continue;
            iter.remove();
            rc = true;
        }
        return rc;
    }

    public static boolean setProperty(Object target, String name, Object value) {
        try {
            Method setter;
            Class<Object> clazz = target.getClass();
            if (target instanceof SSLServerSocket) {
                clazz = SSLServerSocket.class;
            }
            if ((setter = IntrospectionSupport.findSetterMethod(clazz, name)) == null) {
                return false;
            }
            setter.setAccessible(true);
            if (value == null || value.getClass() == setter.getParameterTypes()[0]) {
                setter.invoke(target, value);
            } else {
                setter.invoke(target, IntrospectionSupport.convert(value, setter.getParameterTypes()[0]));
            }
            return true;
        }
        catch (Exception e) {
            LOG.error(String.format("Could not set property %s on %s", name, target), (Throwable)e);
            return false;
        }
    }

    private static Object convert(Object value, Class to) {
        if (value == null) {
            if (Boolean.TYPE.isAssignableFrom(to)) {
                return Boolean.FALSE;
            }
            return null;
        }
        if (to.isAssignableFrom(value.getClass())) {
            return to.cast(value);
        }
        if ((Boolean.TYPE.isAssignableFrom(to) || Boolean.class.isAssignableFrom(to)) && value instanceof String) {
            return Boolean.valueOf((String)value);
        }
        throw new IllegalArgumentException("Cannot convert from " + value.getClass() + " to " + to + " with value " + value);
    }

    private static Method findSetterMethod(Class clazz, String name) {
        Method[] methods;
        name = "set" + Character.toUpperCase(((String)name).charAt(0)) + ((String)name).substring(1);
        for (Method method : methods = clazz.getMethods()) {
            Class<?>[] params = method.getParameterTypes();
            if (!method.getName().equals(name) || params.length != 1) continue;
            return method;
        }
        return null;
    }
}

