/*
 * Decompiled with CFR 0.152.
 */
package org.josql.functions;

import com.gentlyweb.utils.GeneralComparator;
import com.gentlyweb.utils.Getter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.josql.Query;
import org.josql.QueryExecutionException;
import org.josql.expressions.Expression;
import org.josql.functions.AbstractFunctionHandler;
import org.josql.internal.Utilities;

public class CollectionFunctions
extends AbstractFunctionHandler {
    private Map foreachQueryCache = null;
    public static final String HANDLER_ID = "_internal_collection";

    public List sort(List objs) {
        Collections.sort(objs);
        return objs;
    }

    public List sort(Map m) {
        return this.sort(m, "key", "ASC");
    }

    public List sort(Map m, String type) {
        return this.sort(m, type, "ASC");
    }

    public List sort(Map m, String type, String dir) {
        boolean key = true;
        String acc = "key";
        if (type != null && type.equalsIgnoreCase("value")) {
            acc = "value";
        }
        String d = "ASC";
        if (dir != null && (dir = dir.toUpperCase()).equals("DESC")) {
            d = "DESC";
        }
        GeneralComparator gc = new GeneralComparator(Map.Entry.class);
        gc.addField(acc, d);
        ArrayList l = new ArrayList(m.entrySet());
        Collections.sort(l, gc);
        return l;
    }

    public Object get(Map m, Expression exp) throws QueryExecutionException {
        return m.get(exp.getValue(this.q.getCurrentObject(), this.q));
    }

    public Object get(List l, Number n) {
        int i = n.intValue();
        if (i > l.size() || i < 0) {
            return null;
        }
        return l.get(i);
    }

    public int count(List objs, Expression exp, Object value) throws QueryExecutionException {
        Boolean b = Boolean.FALSE;
        if (value != null) {
            b = Boolean.valueOf(value.toString());
        }
        int count = 0;
        ArrayList retVals = new ArrayList();
        int size = objs.size();
        for (int i = 0; i < size; ++i) {
            Object o = objs.get(i);
            Object v = null;
            try {
                if (Utilities.compare(exp.getValue(o, this.q), b) != 0) continue;
                ++count;
                continue;
            }
            catch (Exception e) {
                throw new QueryExecutionException("Unable to get value from expression: " + exp + " for item: " + i + " from the list of objects.", e);
            }
        }
        return count;
    }

    public int count(Expression exp) throws QueryExecutionException {
        return this.count((List)this.q.getVariable(Query.ALL_OBJS_VAR_NAME), exp);
    }

    public int count(List allobjs, Expression exp) throws QueryExecutionException {
        int count = 0;
        ArrayList retVals = new ArrayList();
        int size = allobjs.size();
        for (int i = 0; i < size; ++i) {
            Object o = allobjs.get(i);
            Object v = null;
            try {
                if (!exp.isTrue(o, this.q)) continue;
                ++count;
                continue;
            }
            catch (Exception e) {
                throw new QueryExecutionException("Unable to determine whether expression: \"" + exp + "\" is true for object at index: " + i + " from the list of objects.", e);
            }
        }
        return count;
    }

    public List toList(List allobjs, Expression exp, String saveValueName) throws QueryExecutionException {
        return this.collect(allobjs, exp, saveValueName);
    }

    public List unique(List objs) {
        LinkedHashMap m = new LinkedHashMap();
        int s = objs.size();
        for (int i = 0; i < s; ++i) {
            m.put(objs.get(i), null);
        }
        return new ArrayList(m.keySet());
    }

    public List unique(Expression exp) throws QueryExecutionException {
        return this.unique((List)this.q.getVariable(Query.ALL_OBJS_VAR_NAME), exp);
    }

    public List unique(List objs, Expression exp) throws QueryExecutionException {
        HashMap m = new HashMap();
        int s = objs.size();
        for (int i = 0; i < s; ++i) {
            Object o = objs.get(i);
            o = exp.getValue(o, this.q);
            m.put(o, null);
        }
        return new ArrayList(m.keySet());
    }

    public List collect(List objs, Expression exp, String saveValueName) throws QueryExecutionException {
        Object o;
        if (saveValueName != null && (o = this.q.getSaveValue(saveValueName)) != null) {
            return (List)o;
        }
        ArrayList<Object> retVals = new ArrayList<Object>();
        int s = objs.size();
        Object co = this.q.getCurrentObject();
        for (int i = 0; i < s; ++i) {
            Object o2 = objs.get(i);
            this.q.setCurrentObject(o2);
            Object v = null;
            try {
                retVals.add(exp.getValue(o2, this.q));
                continue;
            }
            catch (Exception e) {
                throw new QueryExecutionException("Unable to execute expression: \"" + exp + " on object at index: " + i + " from the list of objects.", e);
            }
        }
        if (saveValueName != null) {
            this.q.setSaveValue(saveValueName, retVals);
        }
        this.q.setCurrentObject(co);
        return retVals;
    }

    public List collect(Expression exp) throws QueryExecutionException {
        return this.collect((List)this.q.getVariable(Query.ALL_OBJS_VAR_NAME), exp);
    }

    public List collect(List allobjs, Expression exp) throws QueryExecutionException {
        return this.collect(allobjs, exp, null);
    }

    public List toList(Expression exp) throws QueryExecutionException {
        return this.toList((List)this.q.getVariable(Query.ALL_OBJS_VAR_NAME), exp);
    }

    public List toList(List allobjs, Expression exp) throws QueryExecutionException {
        return this.collect(allobjs, exp, null);
    }

    public List foreach(Expression exp) throws QueryExecutionException {
        return this.foreach((List)this.q.getVariable(Query.ALL_OBJS_VAR_NAME), exp);
    }

    public List foreach(List allobjs, Expression exp) throws QueryExecutionException {
        if (allobjs == null) {
            return null;
        }
        ArrayList<Object> res = new ArrayList<Object>();
        int s = allobjs.size();
        for (int i = 0; i < s; ++i) {
            Object o = allobjs.get(i);
            this.q.setCurrentObject(o);
            res.add(exp.getValue(o, this.q));
        }
        return res;
    }

    private void fillMap(Object o, Getter k, Getter v) throws QueryExecutionException {
    }

    public List foreach(List objs, String exp) throws QueryExecutionException {
        ArrayList l = new ArrayList();
        if (objs == null || objs.size() == 0) {
            return l;
        }
        Query q = null;
        if (this.foreachQueryCache != null) {
            q = (Query)this.foreachQueryCache.get(exp);
        }
        if (q == null) {
            Class<?> c = null;
            Object o = objs.get(0);
            if (o == null) {
                int s;
                int i = s = objs.size() - 1;
                while (s > -1) {
                    o = objs.get(i);
                    if (o != null) {
                        c = o.getClass();
                        break;
                    }
                    --i;
                }
            } else {
                c = o.getClass();
            }
            if (exp.toLowerCase().trim().startsWith("where")) {
                exp = exp.trim().substring(5);
            }
            String query = "SELECT * FROM " + c.getName() + " WHERE " + exp;
            q = new Query();
            try {
                q.parse(query);
            }
            catch (Exception e) {
                throw new QueryExecutionException("Unable to create statement using WHERE clause: " + exp + " and class: " + c.getName() + " (gained from objects in list passed in)", e);
            }
            if (this.foreachQueryCache == null) {
                this.foreachQueryCache = new HashMap();
            }
            this.foreachQueryCache.put(exp, q);
        }
        return q.execute(objs).getResults();
    }

    public List foreach(Expression listFunction, Expression exp) throws QueryExecutionException {
        Object o = listFunction.getValue(this.q.getCurrentObject(), this.q);
        if (!(o instanceof List)) {
            throw new QueryExecutionException("Expected expression: " + listFunction + " to return instance of: " + List.class.getName() + " but returned instance of: " + o.getClass().getName());
        }
        List l = (List)o;
        return this.foreach(l, exp);
    }

    public List find(List objs, Expression exp) throws QueryExecutionException {
        Object currobj = this.q.getCurrentObject();
        List allobjs = (List)this.q.getVariable(Query.ALL_OBJS_VAR_NAME);
        this.q.setAllObjects(objs);
        ArrayList r = new ArrayList();
        int s = objs.size();
        for (int i = 0; i < s; ++i) {
            Object o = objs.get(i);
            this.q.setCurrentObject(o);
            try {
                if (!exp.isTrue(o, this.q)) continue;
                r.add(o);
                continue;
            }
            catch (Exception e) {
                throw new QueryExecutionException("Unable to evaulate expression: " + exp + " against object: " + i + " (class: " + o.getClass().getName() + ")", e);
            }
        }
        this.q.setCurrentObject(currobj);
        this.q.setAllObjects(allobjs);
        return r;
    }

    public Map grp(List objs, Expression exp) throws QueryExecutionException {
        Object currobj = this.q.getCurrentObject();
        List allobjs = (List)this.q.getVariable(Query.ALL_OBJS_VAR_NAME);
        this.q.setAllObjects(objs);
        LinkedHashMap<Object, ArrayList<Object>> r = new LinkedHashMap<Object, ArrayList<Object>>();
        int s = objs.size();
        for (int i = 0; i < s; ++i) {
            Object o = objs.get(i);
            this.q.setCurrentObject(o);
            try {
                Object v = exp.getValue(o, this.q);
                ArrayList<Object> vs = (ArrayList<Object>)r.get(v);
                if (vs == null) {
                    vs = new ArrayList<Object>();
                    r.put(v, vs);
                }
                vs.add(v);
                continue;
            }
            catch (Exception e) {
                throw new QueryExecutionException("Unable to evaulate expression: " + exp + " against object: " + i + " (class: " + o.getClass().getName() + ")", e);
            }
        }
        this.q.setCurrentObject(currobj);
        this.q.setAllObjects(allobjs);
        return r;
    }
}

