/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.apache.camel.Component;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.mbean.ManagedResourceEndpointMBean;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.impl.ProcessorEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ResourceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedResource(description="Managed ResourceEndpoint")
public abstract class ResourceEndpoint
extends ProcessorEndpoint
implements ManagedResourceEndpointMBean {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private volatile byte[] buffer;
    @UriPath(description="Path to the resource. You can prefix with: classpath, file, http, ref, or bean. classpath, file and http loads the resource using these protocols (classpath is default). ref will lookup the resource in the registry. bean will call a method on a bean to be used as the resource. For bean you can specify the method name after dot, eg bean:myBean.myMethod.")
    @Metadata(required="true")
    private String resourceUri;
    @UriParam(defaultValue="false", description="Sets whether to use resource content cache or not")
    private boolean contentCache;
    @UriParam(defaultValue="false", description="Sets whether the context map should allow access to all details. By default only the message body and headers can be accessed. This option can be enabled for full access to the current Exchange and CamelContext. Doing so impose a potential security risk as this opens access to the full power of CamelContext API.")
    private boolean allowContextMapAll;

    public ResourceEndpoint() {
    }

    public ResourceEndpoint(String endpointUri, Component component, String resourceUri) {
        super(endpointUri, component);
        this.resourceUri = resourceUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getResourceAsInputStream() throws IOException {
        if (this.isContentCache()) {
            ResourceEndpoint resourceEndpoint = this;
            synchronized (resourceEndpoint) {
                if (this.buffer == null) {
                    this.log.debug("Reading resource: {} into the content cache", (Object)this.resourceUri);
                    InputStream is = this.getResourceAsInputStreamWithoutCache();
                    this.buffer = IOConverter.toBytes(is);
                    IOHelper.close((Closeable)is, this.resourceUri, this.log);
                }
            }
            this.log.debug("Using resource: {} from the content cache", (Object)this.resourceUri);
            return new ByteArrayInputStream(this.buffer);
        }
        return this.getResourceAsInputStreamWithoutCache();
    }

    protected InputStream getResourceAsInputStreamWithoutCache() throws IOException {
        return this.loadResource(this.resourceUri);
    }

    protected InputStream loadResource(String uri) throws IOException {
        return ResourceHelper.resolveMandatoryResourceAsInputStream(this.getCamelContext(), uri);
    }

    @Override
    @ManagedAttribute(description="Whether the resource is cached")
    public boolean isContentCache() {
        return this.contentCache;
    }

    @Override
    @ManagedOperation(description="Clears the cached resource, forcing to re-load the resource on next request")
    public void clearContentCache() {
        this.log.debug("Clearing resource: {} from the content cache", (Object)this.resourceUri);
        this.buffer = null;
    }

    public boolean isContentCacheCleared() {
        return this.buffer == null;
    }

    @ManagedAttribute(description="Whether the context map is limited to only include the message body and headers")
    public boolean isAllowContextMapAll() {
        return this.allowContextMapAll;
    }

    public void setAllowContextMapAll(boolean allowContextMapAll) {
        this.allowContextMapAll = allowContextMapAll;
    }

    @Override
    @ManagedAttribute(description="Camel context ID")
    public String getCamelId() {
        return this.getCamelContext().getName();
    }

    @Override
    @ManagedAttribute(description="Camel ManagementName")
    public String getCamelManagementName() {
        return this.getCamelContext().getManagementName();
    }

    @Override
    @ManagedAttribute(description="Endpoint service state")
    public String getState() {
        return this.getStatus().name();
    }

    @Override
    public void setContentCache(boolean contentCache) {
        this.contentCache = contentCache;
    }

    public String getResourceUri() {
        return this.resourceUri;
    }

    public void setResourceUri(String resourceUri) {
        this.resourceUri = resourceUri;
    }
}

