/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.event.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.shiro.event.EventBus;
import org.apache.shiro.event.support.AnnotationEventListenerResolver;
import org.apache.shiro.event.support.EventListener;
import org.apache.shiro.event.support.EventListenerComparator;
import org.apache.shiro.event.support.EventListenerResolver;
import org.apache.shiro.event.support.SingleArgumentMethodEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEventBus
implements EventBus {
    private static final Logger log = LoggerFactory.getLogger(DefaultEventBus.class);
    private static final String EVENT_LISTENER_ERROR_MSG = "Event listener processing failed.  Listeners should generally handle exceptions directly and not propagate to the event bus.";
    private static final EventListenerComparator EVENT_LISTENER_COMPARATOR = new EventListenerComparator();
    private EventListenerResolver eventListenerResolver;
    private final Map<Object, Subscription> registry = new LinkedHashMap<Object, Subscription>();
    private final Lock registryReadLock;
    private final Lock registryWriteLock;

    public DefaultEventBus() {
        ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
        this.registryReadLock = rwl.readLock();
        this.registryWriteLock = rwl.writeLock();
        this.eventListenerResolver = new AnnotationEventListenerResolver();
    }

    public EventListenerResolver getEventListenerResolver() {
        return this.eventListenerResolver;
    }

    public void setEventListenerResolver(EventListenerResolver eventListenerResolver) {
        this.eventListenerResolver = eventListenerResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(Object event) {
        if (event == null) {
            log.info("Received null event for publishing.  Ignoring and returning.");
            return;
        }
        this.registryReadLock.lock();
        try {
            for (Subscription subscription : this.registry.values()) {
                subscription.onEvent(event);
            }
        }
        finally {
            this.registryReadLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(Object instance) {
        if (instance == null) {
            log.info("Received null instance for event listener registration.  Ignoring registration request.");
            return;
        }
        this.unregister(instance);
        List<EventListener> listeners = this.getEventListenerResolver().getEventListeners(instance);
        if (listeners == null || listeners.isEmpty()) {
            log.warn("Unable to resolve event listeners for subscriber instance [{}]. Ignoring registration request.", instance);
            return;
        }
        Subscription subscription = new Subscription(listeners);
        this.registryWriteLock.lock();
        try {
            this.registry.put(instance, subscription);
        }
        finally {
            this.registryWriteLock.unlock();
        }
    }

    @Override
    public void unregister(Object instance) {
        if (instance == null) {
            return;
        }
        this.registryWriteLock.lock();
        try {
            this.registry.remove(instance);
        }
        finally {
            this.registryWriteLock.unlock();
        }
    }

    private class Subscription {
        private final List<EventListener> listeners;

        public Subscription(List<EventListener> listeners) {
            ArrayList<EventListener> toSort = new ArrayList<EventListener>(listeners);
            Collections.sort(toSort, EVENT_LISTENER_COMPARATOR);
            this.listeners = toSort;
        }

        public void onEvent(Object event) {
            HashSet<Object> delivered = new HashSet<Object>();
            for (EventListener listener : this.listeners) {
                Object target = listener;
                if (listener instanceof SingleArgumentMethodEventListener) {
                    SingleArgumentMethodEventListener singleArgListener = (SingleArgumentMethodEventListener)listener;
                    target = singleArgListener.getTarget();
                }
                if (!listener.accepts(event) || delivered.contains(target)) continue;
                try {
                    listener.onEvent(event);
                }
                catch (Throwable t) {
                    log.warn(DefaultEventBus.EVENT_LISTENER_ERROR_MSG, t);
                }
                delivered.add(target);
            }
        }
    }
}

