/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.compat;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.security.KeyStore;
import java.util.Collections;
import java.util.Map;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.compat.JreCompat;
import org.apache.tomcat.util.res.StringManager;

class Jre8Compat
extends JreCompat {
    private static final Log log = LogFactory.getLog(Jre8Compat.class);
    private static final StringManager sm = StringManager.getManager(Jre8Compat.class);
    private static final int RUNTIME_MAJOR_VERSION = 8;
    private static final Method setUseCipherSuitesOrderMethod;
    private static final Constructor<?> domainLoadStoreParameterConstructor;
    protected static final Method setApplicationProtocolsMethod;
    protected static final Method getApplicationProtocolMethod;

    Jre8Compat() {
    }

    static boolean isSupported() {
        return setUseCipherSuitesOrderMethod != null;
    }

    @Override
    public void setUseServerCipherSuitesOrder(SSLParameters sslParameters, boolean useCipherSuitesOrder) {
        try {
            setUseCipherSuitesOrderMethod.invoke((Object)sslParameters, useCipherSuitesOrder);
        }
        catch (IllegalArgumentException e) {
            throw new UnsupportedOperationException(e);
        }
        catch (IllegalAccessException e) {
            throw new UnsupportedOperationException(e);
        }
        catch (InvocationTargetException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public KeyStore.LoadStoreParameter getDomainLoadStoreParameter(URI uri) {
        try {
            return (KeyStore.LoadStoreParameter)domainLoadStoreParameterConstructor.newInstance(uri, Collections.EMPTY_MAP);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public int jarFileRuntimeMajorVersion() {
        return 8;
    }

    @Override
    public void setApplicationProtocols(SSLParameters sslParameters, String[] protocols) {
        if (setApplicationProtocolsMethod != null) {
            try {
                setApplicationProtocolsMethod.invoke((Object)sslParameters, new Object[]{protocols});
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new UnsupportedOperationException(e);
            }
        } else {
            super.setApplicationProtocols(sslParameters, protocols);
        }
    }

    @Override
    public String getApplicationProtocol(SSLEngine sslEngine) {
        if (getApplicationProtocolMethod != null) {
            try {
                return (String)getApplicationProtocolMethod.invoke((Object)sslEngine, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new UnsupportedOperationException(e);
            }
        }
        return super.getApplicationProtocol(sslEngine);
    }

    public static boolean isAlpnSupported() {
        return setApplicationProtocolsMethod != null && getApplicationProtocolMethod != null;
    }

    static {
        Method m1 = null;
        Constructor<?> c2 = null;
        try {
            Class<?> clazz1 = Class.forName("javax.net.ssl.SSLParameters");
            m1 = clazz1.getMethod("setUseCipherSuitesOrder", Boolean.TYPE);
            Class<?> clazz2 = Class.forName("java.security.DomainLoadStoreParameter");
            c2 = clazz2.getConstructor(URI.class, Map.class);
        }
        catch (SecurityException e) {
            log.error(sm.getString("jre8Compat.unexpected"), e);
        }
        catch (NoSuchMethodException e) {
            if (m1 == null) {
                log.debug(sm.getString("jre8Compat.javaPre8"), e);
            } else {
                log.error(sm.getString("jre8Compat.unexpected"), e);
            }
        }
        catch (ClassNotFoundException e) {
            log.error(sm.getString("jre8Compat.unexpected"), e);
        }
        setUseCipherSuitesOrderMethod = m1;
        domainLoadStoreParameterConstructor = c2;
        Method m2 = null;
        Method m3 = null;
        try {
            m2 = SSLParameters.class.getMethod("setApplicationProtocols", String[].class);
            m3 = SSLEngine.class.getMethod("getApplicationProtocol", new Class[0]);
        }
        catch (IllegalArgumentException | ReflectiveOperationException exception) {
            // empty catch block
        }
        setApplicationProtocolsMethod = m2;
        getApplicationProtocolMethod = m3;
    }
}

