/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.FailedToCreateRouteException;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.Route;
import org.apache.camel.ServiceStatus;
import org.apache.camel.ShutdownRoute;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.StatefulService;
import org.apache.camel.builder.AdviceWithRouteBuilder;
import org.apache.camel.builder.AdviceWithTask;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.ErrorHandlerBuilderRef;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultRouteContext;
import org.apache.camel.model.DescriptionDefinition;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.InputTypeDefinition;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.ModelHelper;
import org.apache.camel.model.OutputTypeDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.PropertyDefinition;
import org.apache.camel.model.RouteDefinitionHelper;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.model.rest.RestBindingDefinition;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.processor.interceptor.HandleFault;
import org.apache.camel.spi.AsEndpointUri;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.spi.RoutePolicyFactory;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.ObjectHelper;

@Metadata(label="configuration")
@XmlRootElement(name="route")
@XmlType(propOrder={"inputs", "inputType", "outputType", "outputs", "routeProperties"})
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class RouteDefinition
extends ProcessorDefinition<RouteDefinition> {
    private final AtomicBoolean prepared = new AtomicBoolean(false);
    private List<FromDefinition> inputs = new ArrayList<FromDefinition>();
    private List<ProcessorDefinition<?>> outputs = new ArrayList();
    private String group;
    private String streamCache;
    private String trace;
    private String messageHistory;
    private String logMask;
    private String handleFault;
    private String delayer;
    private String autoStartup;
    private Integer startupOrder;
    private List<RoutePolicy> routePolicies;
    private String routePolicyRef;
    private ShutdownRoute shutdownRoute;
    private ShutdownRunningTask shutdownRunningTask;
    private String errorHandlerRef;
    private ErrorHandlerFactory errorHandlerBuilder;
    private boolean contextScopedErrorHandler = true;
    private Boolean rest;
    private RestDefinition restDefinition;
    private RestBindingDefinition restBindingDefinition;
    private InputTypeDefinition inputType;
    private OutputTypeDefinition outputType;
    private List<PropertyDefinition> routeProperties;

    public RouteDefinition() {
    }

    public RouteDefinition(@AsEndpointUri String uri) {
        this.from(uri);
    }

    public RouteDefinition(Endpoint endpoint) {
        this.from(endpoint);
    }

    public void fromRest(@AsEndpointUri String uri) {
        this.from(uri);
        this.rest = true;
    }

    public void prepare(ModelCamelContext context) {
        if (this.prepared.compareAndSet(false, true)) {
            RouteDefinitionHelper.prepareRoute(context, this);
        }
    }

    public void markPrepared() {
        this.prepared.set(true);
    }

    public void markUnprepared() {
        this.prepared.set(false);
    }

    public String toString() {
        if (this.getId() != null) {
            return "Route(" + this.getId() + ")[" + this.inputs + " -> " + this.outputs + "]";
        }
        return "Route[" + this.inputs + " -> " + this.outputs + "]";
    }

    @Override
    public String getShortName() {
        return "route";
    }

    public ServiceStatus getStatus(CamelContext camelContext) {
        if (camelContext != null) {
            ServiceStatus answer = camelContext.getRouteStatus(this.getId());
            if (answer == null) {
                answer = ServiceStatus.Stopped;
            }
            return answer;
        }
        return null;
    }

    public boolean isStartable(CamelContext camelContext) {
        ServiceStatus status2 = this.getStatus(camelContext);
        if (status2 == null) {
            return true;
        }
        return status2.isStartable();
    }

    public boolean isStoppable(CamelContext camelContext) {
        ServiceStatus status2 = this.getStatus(camelContext);
        if (status2 == null) {
            return false;
        }
        return status2.isStoppable();
    }

    public List<RouteContext> addRoutes(ModelCamelContext camelContext, Collection<Route> routes) throws Exception {
        ArrayList<RouteContext> answer = new ArrayList<RouteContext>();
        ErrorHandlerBuilder handler = camelContext.getErrorHandlerBuilder();
        if (handler != null) {
            this.setErrorHandlerBuilderIfNull(handler);
        }
        for (FromDefinition fromType : this.inputs) {
            RouteContext routeContext;
            try {
                routeContext = this.addRoutes(camelContext, routes, fromType);
            }
            catch (FailedToCreateRouteException e) {
                throw e;
            }
            catch (Exception e) {
                throw new FailedToCreateRouteException(this.getId(), this.toString(), e);
            }
            answer.add(routeContext);
        }
        return answer;
    }

    public Endpoint resolveEndpoint(CamelContext camelContext, String uri) throws NoSuchEndpointException {
        ObjectHelper.notNull(camelContext, "CamelContext");
        return CamelContextHelper.getMandatoryEndpoint(camelContext, uri);
    }

    public RouteDefinition adviceWith(CamelContext camelContext, RouteBuilder builder) throws Exception {
        return this.adviceWith((ModelCamelContext)camelContext, builder);
    }

    public RouteDefinition adviceWith(ModelCamelContext camelContext, RouteBuilder builder) throws Exception {
        StatefulService service;
        ObjectHelper.notNull(camelContext, "CamelContext");
        ObjectHelper.notNull(builder, "RouteBuilder");
        this.log.debug("AdviceWith route before: {}", (Object)this);
        if (builder instanceof AdviceWithRouteBuilder) {
            ((AdviceWithRouteBuilder)builder).setOriginalRoute(this);
        }
        RoutesDefinition routes = builder.configureRoutes(camelContext);
        this.log.debug("AdviceWith routes: {}", (Object)routes);
        if (!builder.getRouteCollection().getRoutes().isEmpty()) {
            throw new IllegalArgumentException("You can only advice from a RouteBuilder which has no existing routes. Remove all routes from the route builder.");
        }
        if (builder.getRouteCollection().getErrorHandlerBuilder() != null && camelContext.getErrorHandlerBuilder() != builder.getRouteCollection().getErrorHandlerBuilder()) {
            throw new IllegalArgumentException("You can not advice with error handlers. Remove the error handlers from the route builder.");
        }
        String beforeAsXml = ModelHelper.dumpModelAsXml(camelContext, this);
        camelContext.removeRouteDefinition(this);
        if (builder instanceof AdviceWithRouteBuilder) {
            List<AdviceWithTask> tasks = ((AdviceWithRouteBuilder)builder).getAdviceWithTasks();
            for (AdviceWithTask task : tasks) {
                task.task();
            }
        }
        RouteDefinition merged = routes.route(this);
        camelContext.getRouteDefinitions().add(0, merged);
        this.log.info("AdviceWith route after: {}", (Object)merged);
        String afterAsXml = ModelHelper.dumpModelAsXml(camelContext, merged);
        this.log.info("Adviced route before/after as XML:\n{}\n{}", (Object)beforeAsXml, (Object)afterAsXml);
        if (camelContext instanceof StatefulService && (service = (StatefulService)((Object)camelContext)).isStarted()) {
            camelContext.startRoute(merged);
        }
        return merged;
    }

    public RouteDefinition from(@AsEndpointUri String uri) {
        this.getInputs().add(new FromDefinition(uri));
        return this;
    }

    public RouteDefinition from(Endpoint endpoint) {
        this.getInputs().add(new FromDefinition(endpoint));
        return this;
    }

    public RouteDefinition from(String ... uris) {
        for (String uri : uris) {
            this.getInputs().add(new FromDefinition(uri));
        }
        return this;
    }

    public RouteDefinition from(Endpoint ... endpoints) {
        for (Endpoint endpoint : endpoints) {
            this.getInputs().add(new FromDefinition(endpoint));
        }
        return this;
    }

    public RouteDefinition group(String name) {
        this.setGroup(name);
        return this;
    }

    @Override
    public RouteDefinition routeGroup(String group) {
        this.setGroup(group);
        return this;
    }

    @Override
    public RouteDefinition routeId(String id) {
        this.setId(id);
        return this;
    }

    @Override
    public RouteDefinition routeDescription(String description) {
        DescriptionDefinition desc = new DescriptionDefinition();
        desc.setText(description);
        this.setDescription(desc);
        return this;
    }

    public RouteDefinition noStreamCaching() {
        this.setStreamCache("false");
        return this;
    }

    public RouteDefinition streamCaching() {
        this.setStreamCache("true");
        return this;
    }

    public RouteDefinition streamCaching(String streamCache) {
        this.setStreamCache(streamCache);
        return this;
    }

    public RouteDefinition noTracing() {
        this.setTrace("false");
        return this;
    }

    public RouteDefinition tracing() {
        this.setTrace("true");
        return this;
    }

    public RouteDefinition tracing(String tracing) {
        this.setTrace(tracing);
        return this;
    }

    public RouteDefinition messageHistory() {
        this.setMessageHistory("true");
        return this;
    }

    public RouteDefinition messageHistory(String messageHistory) {
        this.setMessageHistory(messageHistory);
        return this;
    }

    public RouteDefinition logMask() {
        this.setLogMask("true");
        return this;
    }

    public RouteDefinition logMask(String logMask) {
        this.setLogMask(logMask);
        return this;
    }

    public RouteDefinition noMessageHistory() {
        this.setMessageHistory("false");
        return this;
    }

    public RouteDefinition noHandleFault() {
        this.setHandleFault("false");
        return this;
    }

    public RouteDefinition handleFault() {
        this.setHandleFault("true");
        return this;
    }

    public RouteDefinition noDelayer() {
        this.setDelayer("0");
        return this;
    }

    public RouteDefinition delayer(long delay) {
        this.setDelayer("" + delay);
        return this;
    }

    public RouteDefinition errorHandler(ErrorHandlerFactory errorHandlerBuilder) {
        this.setErrorHandlerBuilder(errorHandlerBuilder);
        this.contextScopedErrorHandler = false;
        return this;
    }

    public RouteDefinition noAutoStartup() {
        this.setAutoStartup("false");
        return this;
    }

    public RouteDefinition autoStartup(String autoStartup) {
        this.setAutoStartup(autoStartup);
        return this;
    }

    public RouteDefinition autoStartup(boolean autoStartup) {
        this.setAutoStartup(Boolean.toString(autoStartup));
        return this;
    }

    @Override
    public RouteDefinition startupOrder(int order) {
        this.setStartupOrder(order);
        return this;
    }

    public RouteDefinition routePolicy(RoutePolicy ... policies) {
        if (this.routePolicies == null) {
            this.routePolicies = new ArrayList<RoutePolicy>();
        }
        for (RoutePolicy policy : policies) {
            this.routePolicies.add(policy);
        }
        return this;
    }

    public RouteDefinition routePolicyRef(String routePolicyRef) {
        this.setRoutePolicyRef(routePolicyRef);
        return this;
    }

    public RouteDefinition shutdownRoute(ShutdownRoute shutdownRoute) {
        this.setShutdownRoute(shutdownRoute);
        return this;
    }

    public RouteDefinition shutdownRunningTask(ShutdownRunningTask shutdownRunningTask) {
        this.setShutdownRunningTask(shutdownRunningTask);
        return this;
    }

    public RouteDefinition inputType(String urn) {
        this.inputType = new InputTypeDefinition();
        this.inputType.setUrn(urn);
        this.inputType.setValidate(false);
        return this;
    }

    public RouteDefinition inputTypeWithValidate(String urn) {
        this.inputType = new InputTypeDefinition();
        this.inputType.setUrn(urn);
        this.inputType.setValidate(true);
        return this;
    }

    public RouteDefinition inputType(Class clazz) {
        this.inputType = new InputTypeDefinition();
        this.inputType.setJavaClass(clazz);
        this.inputType.setValidate(false);
        return this;
    }

    public RouteDefinition inputTypeWithValidate(Class clazz) {
        this.inputType = new InputTypeDefinition();
        this.inputType.setJavaClass(clazz);
        this.inputType.setValidate(true);
        return this;
    }

    public RouteDefinition outputType(String urn) {
        this.outputType = new OutputTypeDefinition();
        this.outputType.setUrn(urn);
        this.outputType.setValidate(false);
        return this;
    }

    public RouteDefinition outputTypeWithValidate(String urn) {
        this.outputType = new OutputTypeDefinition();
        this.outputType.setUrn(urn);
        this.outputType.setValidate(true);
        return this;
    }

    public RouteDefinition outputType(Class clazz) {
        this.outputType = new OutputTypeDefinition();
        this.outputType.setJavaClass(clazz);
        this.outputType.setValidate(false);
        return this;
    }

    public RouteDefinition outputTypeWithValidate(Class clazz) {
        this.outputType = new OutputTypeDefinition();
        this.outputType.setJavaClass(clazz);
        this.outputType.setValidate(true);
        return this;
    }

    public RouteDefinition routeProperty(String key, String value) {
        if (this.routeProperties == null) {
            this.routeProperties = new ArrayList<PropertyDefinition>();
        }
        PropertyDefinition prop = new PropertyDefinition();
        prop.setKey(key);
        prop.setValue(value);
        this.routeProperties.add(prop);
        return this;
    }

    public List<FromDefinition> getInputs() {
        return this.inputs;
    }

    @XmlElementRef
    public void setInputs(List<FromDefinition> inputs) {
        this.inputs = inputs;
    }

    @Override
    public List<ProcessorDefinition<?>> getOutputs() {
        return this.outputs;
    }

    @XmlElementRef
    public void setOutputs(List<ProcessorDefinition<?>> outputs) {
        this.outputs = outputs;
        if (outputs != null) {
            for (ProcessorDefinition<?> output : outputs) {
                this.configureChild(output);
            }
        }
    }

    @Override
    public boolean isOutputSupported() {
        return true;
    }

    public String getGroup() {
        return this.group;
    }

    @XmlAttribute
    public void setGroup(String group) {
        this.group = group;
    }

    public String getStreamCache() {
        return this.streamCache;
    }

    @XmlAttribute
    public void setStreamCache(String streamCache) {
        this.streamCache = streamCache;
    }

    public String getTrace() {
        return this.trace;
    }

    @XmlAttribute
    public void setTrace(String trace) {
        this.trace = trace;
    }

    public String getMessageHistory() {
        return this.messageHistory;
    }

    @XmlAttribute
    @Metadata(defaultValue="true")
    public void setMessageHistory(String messageHistory) {
        this.messageHistory = messageHistory;
    }

    public String getLogMask() {
        return this.logMask;
    }

    @XmlAttribute
    public void setLogMask(String logMask) {
        this.logMask = logMask;
    }

    public String getHandleFault() {
        return this.handleFault;
    }

    @XmlAttribute
    public void setHandleFault(String handleFault) {
        this.handleFault = handleFault;
    }

    public String getDelayer() {
        return this.delayer;
    }

    @XmlAttribute
    public void setDelayer(String delayer) {
        this.delayer = delayer;
    }

    public String getAutoStartup() {
        return this.autoStartup;
    }

    public boolean isAutoStartup(CamelContext camelContext) throws Exception {
        if (this.getAutoStartup() == null) {
            return true;
        }
        Boolean isAutoStartup = CamelContextHelper.parseBoolean(camelContext, this.getAutoStartup());
        return isAutoStartup != null && isAutoStartup != false;
    }

    @XmlAttribute
    @Metadata(defaultValue="true")
    public void setAutoStartup(String autoStartup) {
        this.autoStartup = autoStartup;
    }

    public Integer getStartupOrder() {
        return this.startupOrder;
    }

    @XmlAttribute
    public void setStartupOrder(Integer startupOrder) {
        this.startupOrder = startupOrder;
    }

    @XmlAttribute
    public void setErrorHandlerRef(String errorHandlerRef) {
        this.errorHandlerRef = errorHandlerRef;
        this.setErrorHandlerBuilder(new ErrorHandlerBuilderRef(errorHandlerRef));
    }

    public String getErrorHandlerRef() {
        return this.errorHandlerRef;
    }

    public void setErrorHandlerBuilderIfNull(ErrorHandlerFactory errorHandlerBuilder) {
        if (this.errorHandlerBuilder == null) {
            this.setErrorHandlerBuilder(errorHandlerBuilder);
        }
    }

    @XmlAttribute
    public void setRoutePolicyRef(String routePolicyRef) {
        this.routePolicyRef = routePolicyRef;
    }

    public String getRoutePolicyRef() {
        return this.routePolicyRef;
    }

    public List<RoutePolicy> getRoutePolicies() {
        return this.routePolicies;
    }

    @XmlTransient
    public void setRoutePolicies(List<RoutePolicy> routePolicies) {
        this.routePolicies = routePolicies;
    }

    public ShutdownRoute getShutdownRoute() {
        return this.shutdownRoute;
    }

    @XmlAttribute
    @Metadata(defaultValue="Default")
    public void setShutdownRoute(ShutdownRoute shutdownRoute) {
        this.shutdownRoute = shutdownRoute;
    }

    public ShutdownRunningTask getShutdownRunningTask() {
        return this.shutdownRunningTask;
    }

    @XmlAttribute
    @Metadata(defaultValue="CompleteCurrentTaskOnly")
    public void setShutdownRunningTask(ShutdownRunningTask shutdownRunningTask) {
        this.shutdownRunningTask = shutdownRunningTask;
    }

    private ErrorHandlerFactory createErrorHandlerBuilder() {
        if (this.errorHandlerRef != null) {
            return new ErrorHandlerBuilderRef(this.errorHandlerRef);
        }
        return new ErrorHandlerBuilderRef("CamelDefaultErrorHandlerBuilder");
    }

    @XmlTransient
    public ErrorHandlerFactory getErrorHandlerBuilder() {
        if (this.errorHandlerBuilder == null) {
            this.errorHandlerBuilder = this.createErrorHandlerBuilder();
        }
        return this.errorHandlerBuilder;
    }

    public void setErrorHandlerBuilder(ErrorHandlerFactory errorHandlerBuilder) {
        this.errorHandlerBuilder = errorHandlerBuilder;
    }

    @XmlAttribute
    public Boolean isRest() {
        return this.rest;
    }

    public RestDefinition getRestDefinition() {
        return this.restDefinition;
    }

    @XmlTransient
    public void setRestDefinition(RestDefinition restDefinition) {
        this.restDefinition = restDefinition;
    }

    public RestBindingDefinition getRestBindingDefinition() {
        return this.restBindingDefinition;
    }

    @XmlTransient
    public void setRestBindingDefinition(RestBindingDefinition restBindingDefinition) {
        this.restBindingDefinition = restBindingDefinition;
    }

    public boolean isContextScopedErrorHandler(CamelContext context) {
        if (!this.contextScopedErrorHandler) {
            return false;
        }
        if (this.errorHandlerRef != null) {
            ErrorHandlerFactory routeScoped = this.getErrorHandlerBuilder();
            ErrorHandlerBuilder contextScoped = context.getErrorHandlerBuilder();
            return routeScoped != null && contextScoped != null && routeScoped == contextScoped;
        }
        return true;
    }

    @XmlElementRef(required=false)
    public void setInputType(InputTypeDefinition inputType) {
        this.inputType = inputType;
    }

    public InputTypeDefinition getInputType() {
        return this.inputType;
    }

    @XmlElementRef(required=false)
    public void setOutputType(OutputTypeDefinition outputType) {
        this.outputType = outputType;
    }

    public OutputTypeDefinition getOutputType() {
        return this.outputType;
    }

    public List<PropertyDefinition> getRouteProperties() {
        return this.routeProperties;
    }

    @XmlElement(name="routeProperty")
    @Metadata(label="advanced")
    public void setRouteProperties(List<PropertyDefinition> routeProperties) {
        this.routeProperties = routeProperties;
    }

    protected RouteContext addRoutes(CamelContext camelContext, Collection<Route> routes, FromDefinition fromType) throws Exception {
        Boolean isAutoStartup;
        RoutePolicy policy;
        Object delayer;
        Boolean isHandleFault;
        Boolean isStreamCache;
        Boolean isLogMask;
        Boolean isMessageHistory;
        Boolean isTrace;
        DefaultRouteContext routeContext = new DefaultRouteContext(camelContext, this, fromType, routes);
        if (this.trace != null && (isTrace = CamelContextHelper.parseBoolean(camelContext, this.getTrace())) != null) {
            routeContext.setTracing(isTrace);
            if (isTrace.booleanValue()) {
                this.log.debug("Tracing is enabled on route: {}", (Object)this.getId());
            }
        }
        if (this.messageHistory != null && (isMessageHistory = CamelContextHelper.parseBoolean(camelContext, this.getMessageHistory())) != null) {
            routeContext.setMessageHistory(isMessageHistory);
            if (isMessageHistory.booleanValue()) {
                this.log.debug("Message history is enabled on route: {}", (Object)this.getId());
            }
        }
        if (this.logMask != null && (isLogMask = CamelContextHelper.parseBoolean(camelContext, this.getLogMask())) != null) {
            routeContext.setLogMask(isLogMask);
            if (isLogMask.booleanValue()) {
                this.log.debug("Security mask for Logging is enabled on route: {}", (Object)this.getId());
            }
        }
        if (this.streamCache != null && (isStreamCache = CamelContextHelper.parseBoolean(camelContext, this.getStreamCache())) != null) {
            routeContext.setStreamCaching(isStreamCache);
            if (isStreamCache.booleanValue()) {
                this.log.debug("StreamCaching is enabled on route: {}", (Object)this.getId());
            }
        }
        if (this.handleFault != null && (isHandleFault = CamelContextHelper.parseBoolean(camelContext, this.getHandleFault())) != null) {
            routeContext.setHandleFault(isHandleFault);
            if (isHandleFault.booleanValue()) {
                this.log.debug("HandleFault is enabled on route: {}", (Object)this.getId());
                if (HandleFault.getHandleFault(camelContext) == null) {
                    this.addInterceptStrategy(new HandleFault());
                }
            }
        }
        if (this.delayer != null && (delayer = CamelContextHelper.parseLong(camelContext, this.getDelayer())) != null) {
            routeContext.setDelayer((Long)delayer);
            if ((Long)delayer > 0L) {
                this.log.debug("Delayer is enabled with: {} ms. on route: {}", delayer, (Object)this.getId());
            } else {
                this.log.debug("Delayer is disabled on route: {}", (Object)this.getId());
            }
        }
        if (this.routePolicies != null && !this.routePolicies.isEmpty()) {
            for (RoutePolicy routePolicy : this.routePolicies) {
                this.log.debug("RoutePolicy is enabled: {} on route: {}", (Object)routePolicy, (Object)this.getId());
                routeContext.getRoutePolicyList().add(routePolicy);
            }
        }
        if (this.routePolicyRef != null) {
            StringTokenizer policyTokens = new StringTokenizer(this.routePolicyRef, ",");
            while (policyTokens.hasMoreTokens()) {
                String string = policyTokens.nextToken().trim();
                policy = CamelContextHelper.mandatoryLookup(camelContext, string, RoutePolicy.class);
                this.log.debug("RoutePolicy is enabled: {} on route: {}", (Object)policy, (Object)this.getId());
                routeContext.getRoutePolicyList().add(policy);
            }
        }
        if (camelContext.getRoutePolicyFactories() != null) {
            for (RoutePolicyFactory routePolicyFactory : camelContext.getRoutePolicyFactories()) {
                policy = routePolicyFactory.createRoutePolicy(camelContext, this.getId(), this);
                if (policy == null) continue;
                this.log.debug("RoutePolicy is enabled: {} on route: {}", (Object)policy, (Object)this.getId());
                routeContext.getRoutePolicyList().add(policy);
            }
        }
        if ((isAutoStartup = CamelContextHelper.parseBoolean(camelContext, this.getAutoStartup())) != null) {
            this.log.debug("Using AutoStartup {} on route: {}", (Object)isAutoStartup, (Object)this.getId());
            routeContext.setAutoStartup(isAutoStartup);
        }
        if (this.shutdownRoute != null) {
            this.log.debug("Using ShutdownRoute {} on route: {}", (Object)this.getShutdownRoute(), (Object)this.getId());
            routeContext.setShutdownRoute(this.getShutdownRoute());
        }
        if (this.shutdownRunningTask != null) {
            this.log.debug("Using ShutdownRunningTask {} on route: {}", (Object)this.getShutdownRunningTask(), (Object)this.getId());
            routeContext.setShutdownRunningTask(this.getShutdownRunningTask());
        }
        routeContext.setInterceptStrategies(this.getInterceptStrategies());
        routeContext.getEndpoint();
        for (LifecycleStrategy strategy : camelContext.getLifecycleStrategies()) {
            strategy.onRouteContextCreate(routeContext);
        }
        if (!ProcessorDefinitionHelper.hasOutputs(this.outputs, true)) {
            RouteDefinition routeDefinition = routeContext.getRoute();
            String at = fromType.toString();
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Route " + routeDefinition.getId() + " has no output processors. You need to add outputs to the route such as to(\"log:foo\").");
            throw new FailedToCreateRouteException(routeDefinition.getId(), routeDefinition.toString(), at, illegalArgumentException);
        }
        ArrayList arrayList = new ArrayList(this.outputs);
        for (ProcessorDefinition processorDefinition : arrayList) {
            try {
                processorDefinition.addRoutes(routeContext, routes);
            }
            catch (Exception e) {
                RouteDefinition route = routeContext.getRoute();
                throw new FailedToCreateRouteException(route.getId(), route.toString(), processorDefinition.toString(), e);
            }
        }
        routeContext.commit();
        return routeContext;
    }

    public static RouteDefinition fromUri(String uri) {
        return new RouteDefinition().from(uri);
    }

    public static RouteDefinition fromEndpoint(Endpoint endpoint) {
        return new RouteDefinition().from(endpoint);
    }
}

