/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.seda;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.Suspendable;
import org.apache.camel.component.seda.SedaEndpoint;
import org.apache.camel.processor.MulticastProcessor;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.ShutdownAware;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.EmptyAsyncCallback;
import org.apache.camel.support.LoggingExceptionHandler;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.AsyncProcessorConverterHelper;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.UnitOfWorkHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SedaConsumer
extends ServiceSupport
implements Consumer,
Runnable,
ShutdownAware,
Suspendable {
    private static final Logger LOG = LoggerFactory.getLogger(SedaConsumer.class);
    private final AtomicInteger taskCount = new AtomicInteger();
    private volatile CountDownLatch latch;
    private volatile boolean shutdownPending;
    private volatile boolean forceShutdown;
    private SedaEndpoint endpoint;
    private AsyncProcessor processor;
    private ExecutorService executor;
    private ExceptionHandler exceptionHandler;
    private final int pollTimeout;

    public SedaConsumer(SedaEndpoint endpoint, Processor processor) {
        this.endpoint = endpoint;
        this.processor = AsyncProcessorConverterHelper.convert(processor);
        this.pollTimeout = endpoint.getPollTimeout();
        this.exceptionHandler = new LoggingExceptionHandler(endpoint.getCamelContext(), this.getClass());
    }

    public String toString() {
        return "SedaConsumer[" + this.endpoint + "]";
    }

    @Override
    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    @Override
    public boolean deferShutdown(ShutdownRunningTask shutdownRunningTask) {
        return true;
    }

    @Override
    public int getPendingExchangesSize() {
        if (this.endpoint.isPurgeWhenStopping()) {
            this.endpoint.purgeQueue();
        }
        return this.endpoint.getQueue().size();
    }

    @Override
    public void prepareShutdown(boolean suspendOnly, boolean forced) {
        if (suspendOnly) {
            LOG.debug("Skip preparing to shutdown as consumer is being suspended");
            return;
        }
        this.shutdownPending = true;
        this.forceShutdown = forced;
        if (this.latch != null) {
            LOG.debug("Preparing to shutdown, waiting for {} consumer threads to complete.", (Object)this.latch.getCount());
            try {
                this.latch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean isRunAllowed() {
        if (this.forceShutdown) {
            return false;
        }
        if (this.isSuspending() || this.isSuspended()) {
            return true;
        }
        return super.isRunAllowed();
    }

    @Override
    public void run() {
        this.taskCount.incrementAndGet();
        try {
            this.doRun();
        }
        finally {
            this.taskCount.decrementAndGet();
            this.latch.countDown();
            LOG.debug("Ending this polling consumer thread, there are still {} consumer threads left.", (Object)this.latch.getCount());
        }
    }

    protected void doRun() {
        BlockingQueue<Exchange> queue2 = this.endpoint.getQueue();
        while (queue2 != null && this.isRunAllowed()) {
            if (this.getEndpoint().getCamelContext().getStatus().isStarting()) {
                LOG.trace("CamelContext is starting so skip polling");
                try {
                    Thread.sleep(Math.min(this.pollTimeout, 1000));
                }
                catch (InterruptedException e) {
                    LOG.debug("Sleep interrupted, are we stopping? {}", (Object)(this.isStopping() || this.isStopped() ? 1 : 0));
                }
                continue;
            }
            if (this.isSuspending() || this.isSuspended() || this.isStarting()) {
                if (this.shutdownPending && queue2.isEmpty()) {
                    LOG.trace("Consumer is suspended and shutdown is pending, so this consumer thread is breaking out because the task queue is empty.");
                    break;
                }
                LOG.trace("Consumer is suspended so skip polling");
                try {
                    Thread.sleep(Math.min(this.pollTimeout, 1000));
                }
                catch (InterruptedException e) {
                    LOG.debug("Sleep interrupted, are we stopping? {}", (Object)(this.isStopping() || this.isStopped() ? 1 : 0));
                }
                continue;
            }
            Exchange exchange = null;
            try {
                exchange = queue2.poll(this.pollTimeout, TimeUnit.MILLISECONDS);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Polled queue {} with timeout {} ms. -> {}", ObjectHelper.getIdentityHashCode(queue2), this.pollTimeout, exchange);
                }
                if (exchange != null) {
                    try {
                        Exchange newExchange = this.prepareExchange(exchange);
                        this.sendToConsumers(newExchange);
                        if (newExchange.hasOut()) {
                            exchange.setOut(newExchange.getOut().copy());
                        } else {
                            exchange.setIn(newExchange.getIn());
                        }
                        if (newExchange.getException() == null) continue;
                        exchange.setException(newExchange.getException());
                        this.getExceptionHandler().handleException("Error processing exchange", exchange, exchange.getException());
                    }
                    catch (Exception e) {
                        this.getExceptionHandler().handleException("Error processing exchange", exchange, e);
                    }
                    continue;
                }
                if (!this.shutdownPending || !queue2.isEmpty()) continue;
                LOG.trace("Shutdown is pending, so this consumer thread is breaking out because the task queue is empty.");
                break;
            }
            catch (InterruptedException e) {
                LOG.debug("Sleep interrupted, are we stopping? {}", (Object)(this.isStopping() || this.isStopped() ? 1 : 0));
            }
            catch (Throwable e) {
                if (exchange != null) {
                    this.getExceptionHandler().handleException("Error processing exchange", exchange, e);
                    continue;
                }
                this.getExceptionHandler().handleException(e);
            }
        }
    }

    protected Exchange prepareExchange(Exchange exchange) {
        Exchange newExchange = ExchangeHelper.copyExchangeAndSetCamelContext(exchange, this.endpoint.getCamelContext());
        newExchange.setFromEndpoint(this.endpoint);
        return newExchange;
    }

    protected void sendToConsumers(final Exchange exchange) throws Exception {
        int size2 = this.endpoint.getConsumers().size();
        if (size2 > 1 && !this.endpoint.isMultipleConsumersSupported()) {
            throw new IllegalStateException("Multiple consumers for the same endpoint is not allowed: " + this.endpoint);
        }
        if (this.endpoint.isMultipleConsumersSupported()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Multicasting to {} consumers for Exchange: {}", (Object)size2, (Object)exchange);
            }
            final List<Synchronization> completions = exchange.handoverCompletions();
            MulticastProcessor mp = this.endpoint.getConsumerMulticastProcessor();
            ObjectHelper.notNull(mp, "ConsumerMulticastProcessor", this);
            mp.process(exchange, new AsyncCallback(){

                @Override
                public void done(boolean doneSync) {
                    UnitOfWorkHelper.doneSynchronizations(exchange, completions, LOG);
                }
            });
        } else {
            this.processor.process(exchange, EmptyAsyncCallback.get());
        }
    }

    @Override
    protected void doStart() throws Exception {
        this.latch = new CountDownLatch(this.endpoint.getConcurrentConsumers());
        this.shutdownPending = false;
        this.forceShutdown = false;
        this.setupTasks();
        this.endpoint.onStarted(this);
    }

    @Override
    protected void doSuspend() throws Exception {
        this.endpoint.onStopped(this);
    }

    @Override
    protected void doResume() throws Exception {
        this.endpoint.onStarted(this);
    }

    @Override
    protected void doStop() throws Exception {
        if (this.endpoint.isPurgeWhenStopping()) {
            this.endpoint.purgeQueue();
        }
        this.endpoint.onStopped(this);
        this.shutdownExecutor();
    }

    @Override
    protected void doShutdown() throws Exception {
        this.shutdownExecutor();
    }

    private void shutdownExecutor() {
        if (this.executor != null) {
            this.endpoint.getCamelContext().getExecutorServiceManager().shutdownNow(this.executor);
            this.executor = null;
        }
    }

    private void setupTasks() {
        int poolSize = this.endpoint.getConcurrentConsumers();
        if (this.executor == null) {
            this.executor = this.endpoint.getCamelContext().getExecutorServiceManager().newFixedThreadPool(this, this.endpoint.getEndpointUri(), poolSize);
        }
        int tasks = poolSize - this.taskCount.get();
        LOG.debug("Creating {} consumer tasks with poll timeout {} ms.", (Object)tasks, (Object)this.pollTimeout);
        for (int i = 0; i < tasks; ++i) {
            this.executor.execute(this);
        }
    }
}

