/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadb.disk.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.activemq.store.kahadb.disk.util.LinkedNodeList;
import org.apache.activemq.store.kahadb.disk.util.Sequence;

public class SequenceSet
extends LinkedNodeList<Sequence>
implements Iterable<Long> {
    public void add(Sequence value) {
        for (long i = value.first; i < value.last + 1L; ++i) {
            this.add(i);
        }
    }

    public void merge(SequenceSet sequenceSet) {
        for (Sequence node = (Sequence)sequenceSet.getHead(); node != null; node = (Sequence)node.getNext()) {
            this.add(node);
        }
    }

    public void remove(SequenceSet sequenceSet) {
        for (Sequence node = (Sequence)sequenceSet.getHead(); node != null; node = (Sequence)node.getNext()) {
            this.remove(node);
        }
    }

    public void remove(Sequence value) {
        for (long i = value.first; i < value.last + 1L; ++i) {
            this.remove(i);
        }
    }

    public boolean add(long value) {
        if (this.isEmpty()) {
            this.addFirst(new Sequence(value));
            return true;
        }
        Sequence sequence = (Sequence)this.getTail();
        if (sequence.isAdjacentToLast(value)) {
            sequence.last = value;
            return true;
        }
        if (sequence.isBiggerButNotAdjacentToLast(value)) {
            this.addLast(new Sequence(value));
            return true;
        }
        for (sequence = (Sequence)this.getHead(); sequence != null; sequence = (Sequence)sequence.getNext()) {
            if (sequence.isAdjacentToLast(value)) {
                Sequence next;
                sequence.last = value;
                if (sequence.getNext() != null && (next = (Sequence)sequence.getNext()).isAdjacentToFirst(value)) {
                    sequence.last = next.last;
                    next.unlink();
                }
                return true;
            }
            if (sequence.isAdjacentToFirst(value)) {
                Sequence prev;
                sequence.first = value;
                if (sequence.getPrevious() != null && (prev = (Sequence)sequence.getPrevious()).isAdjacentToLast(value)) {
                    sequence.first = prev.first;
                    prev.unlink();
                }
                return true;
            }
            if (value < sequence.first) {
                sequence.linkBefore(new Sequence(value));
                return true;
            }
            if (!sequence.contains(value)) continue;
            return false;
        }
        this.addLast(new Sequence(value));
        return true;
    }

    public boolean remove(long value) {
        for (Sequence sequence = (Sequence)this.getHead(); sequence != null; sequence = (Sequence)sequence.getNext()) {
            if (!sequence.contains(value)) continue;
            if (sequence.range() == 1L) {
                sequence.unlink();
                return true;
            }
            if (sequence.getFirst() == value) {
                sequence.setFirst(value + 1L);
                return true;
            }
            if (sequence.getLast() == value) {
                sequence.setLast(value - 1L);
                return true;
            }
            sequence.linkBefore(new Sequence(sequence.first, value - 1L));
            sequence.linkAfter(new Sequence(value + 1L, sequence.last));
            sequence.unlink();
            return true;
        }
        return false;
    }

    public long removeFirst() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        Sequence rc = this.removeFirstSequence(1L);
        return rc.first;
    }

    public Sequence removeLastSequence() {
        if (this.isEmpty()) {
            return null;
        }
        Sequence rc = (Sequence)this.getTail();
        rc.unlink();
        return rc;
    }

    public Sequence removeFirstSequence(long count) {
        if (this.isEmpty()) {
            return null;
        }
        for (Sequence sequence = (Sequence)this.getHead(); sequence != null; sequence = (Sequence)sequence.getNext()) {
            if (sequence.range() == count) {
                sequence.unlink();
                return sequence;
            }
            if (sequence.range() <= count) continue;
            Sequence rc = new Sequence(sequence.first, sequence.first + count - 1L);
            sequence.first += count;
            return rc;
        }
        return null;
    }

    public List<Sequence> getMissing(long first, long last) {
        ArrayList<Sequence> rc = new ArrayList<Sequence>();
        if (first > last) {
            throw new IllegalArgumentException("First cannot be more than last");
        }
        if (this.isEmpty()) {
            rc.add(new Sequence(first, last));
            return rc;
        }
        for (Sequence sequence = (Sequence)this.getHead(); sequence != null && first <= last; sequence = (Sequence)sequence.getNext()) {
            if (sequence.contains(first)) {
                first = sequence.last + 1L;
                continue;
            }
            if (first >= sequence.first) continue;
            if (last < sequence.first) {
                rc.add(new Sequence(first, last));
                return rc;
            }
            rc.add(new Sequence(first, sequence.first - 1L));
            first = sequence.last + 1L;
        }
        if (first <= last) {
            rc.add(new Sequence(first, last));
        }
        return rc;
    }

    public List<Sequence> getReceived() {
        ArrayList<Sequence> rc = new ArrayList<Sequence>(this.size());
        for (Sequence sequence = (Sequence)this.getHead(); sequence != null; sequence = (Sequence)sequence.getNext()) {
            rc.add(new Sequence(sequence.first, sequence.last));
        }
        return rc;
    }

    public boolean contains(long value) {
        if (this.isEmpty()) {
            return false;
        }
        for (Sequence sequence = (Sequence)this.getHead(); sequence != null; sequence = (Sequence)sequence.getNext()) {
            if (!sequence.contains(value)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(int first, int last) {
        if (this.isEmpty()) {
            return false;
        }
        for (Sequence sequence = (Sequence)this.getHead(); sequence != null; sequence = (Sequence)sequence.getNext()) {
            if (sequence.first > (long)first || (long)first > sequence.last) continue;
            return (long)last <= sequence.last;
        }
        return false;
    }

    public Sequence get(int value) {
        if (!this.isEmpty()) {
            for (Sequence sequence = (Sequence)this.getHead(); sequence != null; sequence = (Sequence)sequence.getNext()) {
                if (!sequence.contains(value)) continue;
                return sequence;
            }
        }
        return null;
    }

    public long rangeSize() {
        long result = 0L;
        for (Sequence sequence = (Sequence)this.getHead(); sequence != null; sequence = (Sequence)sequence.getNext()) {
            result += sequence.range();
        }
        return result;
    }

    @Override
    public Iterator<Long> iterator() {
        return new SequenceIterator();
    }

    private class SequenceIterator
    implements Iterator<Long> {
        private Sequence currentEntry;
        private long lastReturned = -1L;

        public SequenceIterator() {
            this.currentEntry = (Sequence)SequenceSet.this.getHead();
            if (this.currentEntry != null) {
                this.lastReturned = this.currentEntry.first - 1L;
            }
        }

        @Override
        public boolean hasNext() {
            return this.currentEntry != null;
        }

        @Override
        public Long next() {
            if (this.currentEntry == null) {
                throw new NoSuchElementException();
            }
            if (this.lastReturned < this.currentEntry.first) {
                this.lastReturned = this.currentEntry.first;
                if (this.currentEntry.range() == 1L) {
                    this.currentEntry = (Sequence)this.currentEntry.getNext();
                }
            } else {
                ++this.lastReturned;
                if (this.lastReturned == this.currentEntry.last) {
                    this.currentEntry = (Sequence)this.currentEntry.getNext();
                }
            }
            return this.lastReturned;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class Marshaller
    implements org.apache.activemq.store.kahadb.disk.util.Marshaller<SequenceSet> {
        public static final Marshaller INSTANCE = new Marshaller();

        @Override
        public SequenceSet readPayload(DataInput in) throws IOException {
            SequenceSet value = new SequenceSet();
            int count = in.readInt();
            for (int i = 0; i < count; ++i) {
                Sequence sequence;
                if (in.readBoolean()) {
                    sequence = new Sequence(in.readLong(), in.readLong());
                    value.addLast(sequence);
                    continue;
                }
                sequence = new Sequence(in.readLong());
                value.addLast(sequence);
            }
            return value;
        }

        @Override
        public void writePayload(SequenceSet value, DataOutput out) throws IOException {
            out.writeInt(value.size());
            for (Sequence sequence = (Sequence)value.getHead(); sequence != null; sequence = (Sequence)sequence.getNext()) {
                if (sequence.range() > 1L) {
                    out.writeBoolean(true);
                    out.writeLong(sequence.first);
                    out.writeLong(sequence.last);
                    continue;
                }
                out.writeBoolean(false);
                out.writeLong(sequence.first);
            }
        }

        @Override
        public int getFixedSize() {
            return -1;
        }

        @Override
        public SequenceSet deepCopy(SequenceSet value) {
            SequenceSet rc = new SequenceSet();
            for (Sequence sequence = (Sequence)value.getHead(); sequence != null; sequence = (Sequence)sequence.getNext()) {
                rc.add(new Sequence(sequence.first, sequence.last));
            }
            return rc;
        }

        @Override
        public boolean isDeepCopySupported() {
            return true;
        }
    }
}

