/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jsr356;

import java.io.IOException;
import java.net.URI;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.websocket.CloseReason;
import javax.websocket.EndpointConfig;
import javax.websocket.Extension;
import javax.websocket.MessageHandler;
import javax.websocket.RemoteEndpoint;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.BatchMode;
import org.eclipse.jetty.websocket.common.LogicalConnection;
import org.eclipse.jetty.websocket.common.WebSocketSession;
import org.eclipse.jetty.websocket.common.events.EventDriver;
import org.eclipse.jetty.websocket.jsr356.ClientContainer;
import org.eclipse.jetty.websocket.jsr356.Configurable;
import org.eclipse.jetty.websocket.jsr356.DecoderFactory;
import org.eclipse.jetty.websocket.jsr356.EncoderFactory;
import org.eclipse.jetty.websocket.jsr356.JsrAsyncRemote;
import org.eclipse.jetty.websocket.jsr356.JsrBasicRemote;
import org.eclipse.jetty.websocket.jsr356.JsrExtension;
import org.eclipse.jetty.websocket.jsr356.MessageHandlerFactory;
import org.eclipse.jetty.websocket.jsr356.MessageHandlerWrapper;
import org.eclipse.jetty.websocket.jsr356.MessageType;
import org.eclipse.jetty.websocket.jsr356.endpoints.AbstractJsrEventDriver;
import org.eclipse.jetty.websocket.jsr356.metadata.DecoderMetadata;
import org.eclipse.jetty.websocket.jsr356.metadata.EndpointMetadata;
import org.eclipse.jetty.websocket.jsr356.metadata.MessageHandlerMetadata;

public class JsrSession
extends WebSocketSession
implements Session,
Configurable {
    private static final Logger LOG = Log.getLogger(JsrSession.class);
    private final ClientContainer container;
    private final String id;
    private final EndpointConfig config;
    private final EndpointMetadata metadata;
    private final DecoderFactory decoderFactory;
    private final EncoderFactory encoderFactory;
    private final MessageHandlerFactory messageHandlerFactory;
    private final MessageHandlerWrapper[] wrappers;
    private Set<MessageHandler> messageHandlerSet;
    private List<Extension> negotiatedExtensions;
    private Map<String, String> pathParameters = new HashMap<String, String>();
    private JsrAsyncRemote asyncRemote;
    private JsrBasicRemote basicRemote;

    public JsrSession(ClientContainer container, String id, URI requestURI, EventDriver websocket, LogicalConnection connection) {
        super(container, requestURI, websocket, connection);
        if (!(websocket instanceof AbstractJsrEventDriver)) {
            throw new IllegalArgumentException("Cannot use, not a JSR WebSocket: " + websocket);
        }
        AbstractJsrEventDriver jsr = (AbstractJsrEventDriver)websocket;
        this.config = jsr.getConfig();
        this.metadata = jsr.getMetadata();
        this.container = container;
        this.id = id;
        this.decoderFactory = new DecoderFactory(this, this.metadata.getDecoders(), container.getDecoderFactory());
        this.encoderFactory = new EncoderFactory(this, this.metadata.getEncoders(), container.getEncoderFactory());
        this.messageHandlerFactory = new MessageHandlerFactory();
        this.wrappers = new MessageHandlerWrapper[MessageType.values().length];
        this.messageHandlerSet = new HashSet<MessageHandler>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMessageHandler(MessageHandler handler) throws IllegalStateException {
        Objects.requireNonNull(handler, "MessageHandler cannot be null");
        MessageHandlerWrapper[] messageHandlerWrapperArray = this.wrappers;
        synchronized (this.wrappers) {
            for (MessageHandlerMetadata metadata : this.messageHandlerFactory.getMetadata(handler.getClass())) {
                MessageHandlerWrapper handlerWrapper;
                DecoderFactory.Wrapper wrapper = this.decoderFactory.getWrapperFor(metadata.getMessageClass());
                if (wrapper == null) {
                    StringBuilder err = new StringBuilder();
                    err.append("Unable to find decoder for type <");
                    err.append(metadata.getMessageClass().getName());
                    err.append("> used in <");
                    err.append(metadata.getHandlerClass().getName());
                    err.append(">");
                    throw new IllegalStateException(err.toString());
                }
                MessageType key = wrapper.getMetadata().getMessageType();
                MessageHandlerWrapper other = this.wrappers[key.ordinal()];
                if (other != null) {
                    StringBuilder err = new StringBuilder();
                    err.append("Encountered duplicate MessageHandler handling message type <");
                    err.append(wrapper.getMetadata().getObjectType().getName());
                    err.append(">, ").append(metadata.getHandlerClass().getName());
                    err.append("<");
                    err.append(metadata.getMessageClass().getName());
                    err.append("> and ");
                    err.append(other.getMetadata().getHandlerClass().getName());
                    err.append("<");
                    err.append(other.getMetadata().getMessageClass().getName());
                    err.append("> both implement this message type");
                    throw new IllegalStateException(err.toString());
                }
                this.wrappers[key.ordinal()] = handlerWrapper = new MessageHandlerWrapper(handler, metadata, wrapper);
            }
            this.updateMessageHandlerSet();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void close(CloseReason closeReason) throws IOException {
        this.close(closeReason.getCloseCode().getCode(), closeReason.getReasonPhrase());
    }

    @Override
    public RemoteEndpoint.Async getAsyncRemote() {
        if (this.asyncRemote == null) {
            this.asyncRemote = new JsrAsyncRemote(this);
        }
        return this.asyncRemote;
    }

    @Override
    public RemoteEndpoint.Basic getBasicRemote() {
        if (this.basicRemote == null) {
            this.basicRemote = new JsrBasicRemote(this);
        }
        return this.basicRemote;
    }

    @Override
    public WebSocketContainer getContainer() {
        return this.container;
    }

    public DecoderFactory getDecoderFactory() {
        return this.decoderFactory;
    }

    public EncoderFactory getEncoderFactory() {
        return this.encoderFactory;
    }

    public EndpointConfig getEndpointConfig() {
        return this.config;
    }

    public EndpointMetadata getEndpointMetadata() {
        return this.metadata;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public int getMaxBinaryMessageBufferSize() {
        return this.getPolicy().getMaxBinaryMessageSize();
    }

    @Override
    public long getMaxIdleTimeout() {
        return this.getPolicy().getIdleTimeout();
    }

    @Override
    public int getMaxTextMessageBufferSize() {
        return this.getPolicy().getMaxTextMessageSize();
    }

    public MessageHandlerFactory getMessageHandlerFactory() {
        return this.messageHandlerFactory;
    }

    @Override
    public Set<MessageHandler> getMessageHandlers() {
        return new HashSet<MessageHandler>(this.messageHandlerSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageHandlerWrapper getMessageHandlerWrapper(MessageType type) {
        MessageHandlerWrapper[] messageHandlerWrapperArray = this.wrappers;
        synchronized (this.wrappers) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.wrappers[type.ordinal()];
        }
    }

    @Override
    public List<Extension> getNegotiatedExtensions() {
        if (this.negotiatedExtensions == null && this.getUpgradeResponse().getExtensions() != null) {
            this.negotiatedExtensions = this.getUpgradeResponse().getExtensions().stream().map(JsrExtension::new).collect(Collectors.toList());
        }
        return this.negotiatedExtensions;
    }

    @Override
    public String getNegotiatedSubprotocol() {
        String acceptedSubProtocol = this.getUpgradeResponse().getAcceptedSubProtocol();
        if (acceptedSubProtocol == null) {
            return "";
        }
        return acceptedSubProtocol;
    }

    @Override
    public Set<Session> getOpenSessions() {
        return this.container.getOpenSessions();
    }

    @Override
    public Map<String, String> getPathParameters() {
        return Collections.unmodifiableMap(this.pathParameters);
    }

    @Override
    public String getQueryString() {
        return this.getUpgradeRequest().getRequestURI().getQuery();
    }

    @Override
    public Map<String, List<String>> getRequestParameterMap() {
        return this.getUpgradeRequest().getParameterMap();
    }

    @Override
    public Principal getUserPrincipal() {
        return this.getUpgradeRequest().getUserPrincipal();
    }

    @Override
    public Map<String, Object> getUserProperties() {
        return this.config.getUserProperties();
    }

    @Override
    public void init(EndpointConfig config) {
        this.encoderFactory.init(config);
        this.decoderFactory.init(config);
    }

    @Override
    public void destroy() {
        this.encoderFactory.destroy();
        this.decoderFactory.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMessageHandler(MessageHandler handler) {
        MessageHandlerWrapper[] messageHandlerWrapperArray = this.wrappers;
        synchronized (this.wrappers) {
            try {
                for (MessageHandlerMetadata metadata : this.messageHandlerFactory.getMetadata(handler.getClass())) {
                    DecoderMetadata decoder = this.decoderFactory.getMetadataFor(metadata.getMessageClass());
                    MessageType key = decoder.getMessageType();
                    this.wrappers[key.ordinal()] = null;
                }
                this.updateMessageHandlerSet();
            }
            catch (IllegalStateException e) {
                LOG.warn("Unable to identify MessageHandler: " + handler.getClass().getName(), e);
            }
            return;
        }
    }

    @Override
    public void setMaxBinaryMessageBufferSize(int length) {
        this.getPolicy().setMaxBinaryMessageBufferSize(length);
        this.getPolicy().setMaxBinaryMessageSize(length);
    }

    @Override
    public void setMaxIdleTimeout(long milliseconds) {
        this.getPolicy().setIdleTimeout(milliseconds);
        super.setIdleTimeout(milliseconds);
    }

    @Override
    public void setMaxTextMessageBufferSize(int length) {
        this.getPolicy().setMaxTextMessageBufferSize(length);
        this.getPolicy().setMaxTextMessageSize(length);
    }

    public void setPathParameters(Map<String, String> pathParams) {
        this.pathParameters.clear();
        if (pathParams != null) {
            this.pathParameters.putAll(pathParams);
        }
    }

    private void updateMessageHandlerSet() {
        this.messageHandlerSet.clear();
        for (MessageHandlerWrapper wrapper : this.wrappers) {
            if (wrapper == null) continue;
            this.messageHandlerSet.add(wrapper.getHandler());
        }
    }

    @Override
    public BatchMode getBatchMode() {
        return BatchMode.OFF;
    }
}

