/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jsr356;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.websocket.Encoder;
import javax.websocket.EndpointConfig;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.common.scopes.WebSocketContainerScope;
import org.eclipse.jetty.websocket.common.scopes.WebSocketSessionScope;
import org.eclipse.jetty.websocket.jsr356.Configurable;
import org.eclipse.jetty.websocket.jsr356.metadata.EncoderMetadata;
import org.eclipse.jetty.websocket.jsr356.metadata.EncoderMetadataSet;

public class EncoderFactory
implements Configurable {
    private static final Logger LOG = Log.getLogger(EncoderFactory.class);
    private final EncoderMetadataSet metadatas;
    private final WebSocketContainerScope containerScope;
    private final Map<Class<?>, Wrapper> activeWrappers;
    private final EncoderFactory parentFactory;
    private EndpointConfig endpointConfig;

    public EncoderFactory(WebSocketContainerScope containerScope, EncoderMetadataSet metadatas) {
        this(containerScope, metadatas, null);
    }

    public EncoderFactory(WebSocketSessionScope sessionScope, EncoderMetadataSet metadatas, EncoderFactory parentFactory) {
        this(sessionScope.getContainerScope(), metadatas, parentFactory);
    }

    protected EncoderFactory(WebSocketContainerScope containerScope, EncoderMetadataSet metadatas, EncoderFactory parentFactory) {
        Objects.requireNonNull(containerScope, "Container Scope cannot be null");
        this.containerScope = containerScope;
        this.metadatas = metadatas;
        this.activeWrappers = new ConcurrentHashMap();
        this.parentFactory = parentFactory;
    }

    public Encoder getEncoderFor(Class<?> type) {
        Wrapper wrapper = this.getWrapperFor(type);
        if (wrapper == null) {
            return null;
        }
        return wrapper.encoder;
    }

    public EncoderMetadata getMetadataFor(Class<?> type) {
        EncoderMetadata metadata;
        if (LOG.isDebugEnabled()) {
            LOG.debug("getMetadataFor({})", type);
        }
        if ((metadata = (EncoderMetadata)this.metadatas.getMetadataByType(type)) != null) {
            return metadata;
        }
        if (this.parentFactory != null) {
            return this.parentFactory.getMetadataFor(type);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Wrapper getWrapperFor(Class<?> type) {
        Map<Class<?>, Wrapper> map = this.activeWrappers;
        synchronized (map) {
            Wrapper wrapper = this.activeWrappers.get(type);
            if (wrapper == null && this.parentFactory != null) {
                wrapper = this.parentFactory.getWrapperFor(type);
            }
            if (wrapper == null) {
                EncoderMetadata metadata = (EncoderMetadata)this.metadatas.getMetadataByType(type);
                if (metadata == null) {
                    return null;
                }
                wrapper = this.newWrapper(metadata);
                this.activeWrappers.put(type, wrapper);
            }
            return wrapper;
        }
    }

    @Override
    public void init(EndpointConfig config) {
        this.endpointConfig = config;
        if (LOG.isDebugEnabled()) {
            LOG.debug("init({})", this.endpointConfig);
        }
        for (EncoderMetadata metadata : this.metadatas) {
            Wrapper wrapper = this.newWrapper(metadata);
            this.activeWrappers.put(metadata.getObjectType(), wrapper);
        }
    }

    @Override
    public void destroy() {
        for (Wrapper wrapper : this.activeWrappers.values()) {
            wrapper.encoder.destroy();
        }
        this.activeWrappers.clear();
    }

    private Wrapper newWrapper(EncoderMetadata metadata) {
        if (this.endpointConfig == null) {
            throw new IllegalStateException("EndpointConfig not set");
        }
        Class encoderClass = metadata.getCoderClass();
        try {
            Encoder encoder = (Encoder)this.containerScope.getObjectFactory().createInstance(encoderClass);
            encoder.init(this.endpointConfig);
            return new Wrapper(encoder, metadata);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to instantiate Encoder: " + encoderClass.getName(), e);
        }
    }

    public static class Wrapper
    implements Configurable {
        private final Encoder encoder;
        private final EncoderMetadata metadata;

        private Wrapper(Encoder encoder, EncoderMetadata metadata) {
            this.encoder = encoder;
            this.metadata = metadata;
        }

        public Encoder getEncoder() {
            return this.encoder;
        }

        public EncoderMetadata getMetadata() {
            return this.metadata;
        }

        @Override
        public void init(EndpointConfig config) {
            this.encoder.init(config);
        }

        @Override
        public void destroy() {
            this.encoder.destroy();
        }
    }
}

