/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.logging;

import java.util.logging.Logger;
import org.apache.qpid.proton.engine.impl.ProtocolTracer;
import org.apache.qpid.proton.framing.TransportFrame;

public class LoggingProtocolTracer
implements ProtocolTracer {
    private static final String LOGGER_NAME_STEM = LoggingProtocolTracer.class.getName();
    private static final Logger RECEIVED_LOGGER = Logger.getLogger(LOGGER_NAME_STEM + ".received");
    private static final Logger SENT_LOGGER = Logger.getLogger(LOGGER_NAME_STEM + ".sent");
    private String _logMessagePrefix;

    public LoggingProtocolTracer() {
        this("Transport");
    }

    public LoggingProtocolTracer(String logMessagePrefix) {
        this._logMessagePrefix = logMessagePrefix;
    }

    @Override
    public void receivedFrame(TransportFrame transportFrame) {
        RECEIVED_LOGGER.finer(this._logMessagePrefix + " received frame: " + transportFrame);
    }

    @Override
    public void sentFrame(TransportFrame transportFrame) {
        SENT_LOGGER.finer(this._logMessagePrefix + " writing frame: " + transportFrame);
    }

    public void setLogMessagePrefix(String logMessagePrefix) {
        this._logMessagePrefix = logMessagePrefix;
    }
}

