/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.cloud;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.camel.cloud.ServiceDefinition;
import org.apache.camel.cloud.ServiceFilter;
import org.apache.camel.impl.cloud.DefaultServiceDefinition;
import org.apache.camel.util.StringHelper;

public class BlacklistServiceFilter
implements ServiceFilter {
    private List<ServiceDefinition> services;

    public BlacklistServiceFilter() {
        this.services = new ArrayList<ServiceDefinition>();
    }

    public BlacklistServiceFilter(List<ServiceDefinition> blacklist) {
        this.services = new ArrayList<ServiceDefinition>(blacklist);
    }

    public void setServers(List<String> servers) {
        this.services.clear();
        servers.forEach(this::addServer);
    }

    public void setServers(String servers) {
        this.services.clear();
        this.addServer(servers);
    }

    public void addServer(ServiceDefinition server) {
        this.services.add(server);
    }

    public void addServer(String serverString) {
        String[] parts;
        for (String part : parts = serverString.split(",")) {
            String service = StringHelper.before(part, "@");
            if (service != null) {
                part = StringHelper.after(part, "@");
            }
            String host = StringHelper.before(part, ":");
            String port = StringHelper.after(part, ":");
            this.addServer(service, host, Integer.valueOf(port));
        }
    }

    public void addServer(String host, int port) {
        this.addServer(null, host, port, null);
    }

    public void addServer(String name, String host, int port) {
        this.addServer(name, host, port, null);
    }

    public void addServer(String name, String host, int port, Map<String, String> meta) {
        this.services.add(new DefaultServiceDefinition(name, host, port, meta));
    }

    @Override
    public List<ServiceDefinition> apply(List<ServiceDefinition> services) {
        return services.stream().filter(s -> !this.services.contains(s)).collect(Collectors.toList());
    }

    List<ServiceDefinition> getBlacklistedServices() {
        return Collections.unmodifiableList(this.services);
    }

    public static BlacklistServiceFilter forServices(Collection<ServiceDefinition> definitions) {
        BlacklistServiceFilter filter = new BlacklistServiceFilter();
        for (ServiceDefinition definition : definitions) {
            filter.addServer(definition);
        }
        return filter;
    }

    public static BlacklistServiceFilter forServices(ServiceDefinition ... definitions) {
        BlacklistServiceFilter filter = new BlacklistServiceFilter();
        for (ServiceDefinition definition : definitions) {
            filter.addServer(definition);
        }
        return filter;
    }
}

