/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdispatch.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.fusesource.hawtdispatch.DispatchQueue;
import org.fusesource.hawtdispatch.Task;
import org.fusesource.hawtdispatch.internal.HawtDispatcher;
import org.fusesource.hawtdispatch.internal.util.TimerHeap;

public final class TimerThread
extends Thread {
    private final Object mutex = new Object();
    private ArrayList<TimerRequest> requests = new ArrayList();

    public TimerThread(HawtDispatcher dispatcher) {
        this.setName(dispatcher.getLabel() + " timer");
        this.setDaemon(true);
    }

    public final void addAbsolute(Task task, DispatchQueue target, long time, TimeUnit unit) {
        TimerRequest request = new TimerRequest();
        request.type = Type.ABSOLUTE;
        request.time = time;
        request.unit = unit;
        request.task = task;
        request.target = target;
        this.add(request);
    }

    public final void addRelative(Task task, DispatchQueue target, long delay, TimeUnit unit) {
        TimerRequest request = new TimerRequest();
        request.type = Type.RELATIVE;
        request.time = delay;
        request.unit = unit;
        request.task = task;
        request.target = target;
        this.add(request);
    }

    public final void shutdown(Task onShutdown, DispatchQueue target) {
        TimerRequest request = new TimerRequest();
        request.type = Type.SHUTDOWN;
        request.target = target;
        request.task = onShutdown;
        this.add(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(TimerRequest request) {
        Object object = this.mutex;
        synchronized (object) {
            this.requests.add(request);
            this.mutex.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        final HashMap readyRequests = new HashMap();
        TimerHeap<TimerRequest> timerHeap = new TimerHeap<TimerRequest>(){

            @Override
            public final void execute(TimerRequest request) {
                LinkedList<Task> tasks = (LinkedList<Task>)readyRequests.get(request.target);
                if (tasks == null) {
                    tasks = new LinkedList<Task>();
                    readyRequests.put(request.target, tasks);
                }
                tasks.add(request.task);
            }
        };
        ArrayList<Object> swapped = new ArrayList();
        try {
            block11: while (true) {
                Object object = this.mutex;
                // MONITORENTER : object
                ArrayList<TimerRequest> arrayList = this.requests;
                this.requests = swapped;
                swapped = arrayList;
                // MONITOREXIT : object
                if (!swapped.isEmpty()) {
                    for (TimerRequest timerRequest : swapped) {
                        switch (timerRequest.type) {
                            case RELATIVE: {
                                timerHeap.addRelative(timerRequest, timerRequest.time, timerRequest.unit);
                                break;
                            }
                            case ABSOLUTE: {
                                timerHeap.addAbsolute(timerRequest, timerRequest.time, timerRequest.unit);
                                break;
                            }
                            case SHUTDOWN: {
                                List requests = timerHeap.clear();
                                Iterator i$ = requests.iterator();
                                while (true) {
                                    if (!i$.hasNext()) {
                                        if (timerRequest.task == null) return;
                                        timerRequest.task.run();
                                        return;
                                    }
                                    TimerRequest r = (TimerRequest)i$.next();
                                    r.target.execute(r.task);
                                }
                            }
                        }
                    }
                    swapped.clear();
                }
                timerHeap.executeReadyTimers();
                if (!readyRequests.isEmpty()) {
                    for (Map.Entry entry : readyRequests.entrySet()) {
                        DispatchQueue queue = (DispatchQueue)entry.getKey();
                        final LinkedList tasks = (LinkedList)entry.getValue();
                        if (tasks.size() > 1) {
                            queue.execute(new Task(){

                                public void run() {
                                    for (Task task : tasks) {
                                        task.run();
                                    }
                                }
                            });
                            continue;
                        }
                        queue.execute((Task)tasks.getFirst());
                    }
                    readyRequests.clear();
                }
                long start = System.nanoTime();
                long next = timerHeap.timeToNext(TimeUnit.NANOSECONDS);
                if (next == 0L) continue;
                if (next > 0L && next < 1000L) {
                    while (true) {
                        if (System.nanoTime() - start >= next) continue block11;
                    }
                }
                long waitms = next / 1000000L;
                int waitns = (int)(next % 1000000L);
                Object object2 = this.mutex;
                // MONITORENTER : object2
                if (this.requests.isEmpty()) {
                    if (next == -1L) {
                        this.mutex.wait();
                    } else {
                        this.mutex.wait(waitms, waitns);
                    }
                }
                // MONITOREXIT : object2
            }
        }
        catch (InterruptedException e) {
            return;
        }
    }

    private static final class TimerRequest {
        Type type;
        long time;
        TimeUnit unit;
        Task task;
        DispatchQueue target;

        private TimerRequest() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Type {
        RELATIVE,
        ABSOLUTE,
        SHUTDOWN;

    }
}

