/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileExist;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.LRUCache;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericFileProducer<T>
extends DefaultProducer {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final GenericFileEndpoint<T> endpoint;
    protected GenericFileOperations<T> operations;
    private final LRUCache<String, Lock> locks = new LRUCache(100);

    protected GenericFileProducer(GenericFileEndpoint<T> endpoint, GenericFileOperations<T> operations) {
        super(endpoint);
        this.endpoint = endpoint;
        this.operations = operations;
    }

    public String getFileSeparator() {
        return File.separator;
    }

    public String normalizePath(String name) {
        return FileUtil.normalizePath(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Exchange exchange) throws Exception {
        Lock lock;
        String existing = exchange.getIn().getHeader("CamelFileName", String.class);
        String target = this.createFileName(exchange);
        LRUCache<String, Lock> lRUCache = this.locks;
        synchronized (lRUCache) {
            lock = this.locks.get(target);
            if (lock == null) {
                lock = new ReentrantLock();
                this.locks.put(target, lock);
            }
        }
        lock.lock();
        try {
            this.processExchange(exchange, target);
        }
        finally {
            lock.unlock();
            exchange.getIn().removeHeader("CamelOverruleFileName");
            exchange.getIn().setHeader("CamelFileName", existing);
        }
    }

    public void setOperations(GenericFileOperations<T> operations) {
        this.operations = operations;
    }

    protected void processExchange(Exchange exchange, String target) throws Exception {
        this.log.trace("Processing file: {} for exchange: {}", (Object)target, (Object)exchange);
        try {
            Boolean targetExists;
            this.preWriteCheck();
            boolean writeAsTempAndRename = ObjectHelper.isNotEmpty(this.endpoint.getTempFileName());
            String tempTarget = null;
            if (writeAsTempAndRename) {
                tempTarget = this.createTempFileName(exchange, target);
                this.log.trace("Writing using tempNameFile: {}", (Object)tempTarget);
                if (this.endpoint.getFileExist() != GenericFileExist.TryRename && this.endpoint.isEagerDeleteTargetFile() && (targetExists = Boolean.valueOf(this.operations.existsFile(target))).booleanValue()) {
                    this.log.trace("EagerDeleteTargetFile, target exists");
                    if (this.endpoint.getFileExist() == GenericFileExist.Ignore) {
                        this.log.trace("An existing file already exists: {}. Ignore and do not override it.", (Object)target);
                        return;
                    }
                    if (this.endpoint.getFileExist() == GenericFileExist.Fail) {
                        throw new GenericFileOperationFailedException("File already exist: " + target + ". Cannot write new file.");
                    }
                    if (this.endpoint.getFileExist() == GenericFileExist.Move) {
                        this.doMoveExistingFile(target);
                    } else if (this.endpoint.isEagerDeleteTargetFile() && this.endpoint.getFileExist() == GenericFileExist.Override) {
                        this.log.trace("Eagerly deleting existing file: {}", (Object)target);
                        if (!this.operations.deleteFile(target)) {
                            throw new GenericFileOperationFailedException("Cannot delete file: " + target);
                        }
                    }
                }
                if (this.operations.existsFile(tempTarget)) {
                    this.log.trace("Deleting existing temp file: {}", (Object)tempTarget);
                    if (!this.operations.deleteFile(tempTarget)) {
                        throw new GenericFileOperationFailedException("Cannot delete file: " + tempTarget);
                    }
                }
            }
            this.writeFile(exchange, tempTarget != null ? tempTarget : target);
            if (tempTarget != null) {
                if (this.endpoint.getFileExist() != GenericFileExist.TryRename && !this.endpoint.isEagerDeleteTargetFile() && (targetExists = Boolean.valueOf(this.operations.existsFile(target))).booleanValue()) {
                    this.log.trace("Not using EagerDeleteTargetFile, target exists");
                    if (this.endpoint.getFileExist() == GenericFileExist.Ignore) {
                        this.log.trace("An existing file already exists: {}. Ignore and do not override it.", (Object)target);
                        return;
                    }
                    if (this.endpoint.getFileExist() == GenericFileExist.Fail) {
                        throw new GenericFileOperationFailedException("File already exist: " + target + ". Cannot write new file.");
                    }
                    if (this.endpoint.getFileExist() == GenericFileExist.Override) {
                        this.log.trace("Deleting existing file: {}", (Object)target);
                        if (!this.operations.deleteFile(target)) {
                            throw new GenericFileOperationFailedException("Cannot delete file: " + target);
                        }
                    }
                }
                this.log.trace("Renaming file: [{}] to: [{}]", (Object)tempTarget, (Object)target);
                boolean renamed = this.operations.renameFile(tempTarget, target);
                if (!renamed) {
                    throw new GenericFileOperationFailedException("Cannot rename file from: " + tempTarget + " to: " + target);
                }
            }
            if (this.endpoint.getDoneFileName() != null) {
                String doneFileName = this.endpoint.createDoneFileName(target);
                ObjectHelper.notEmpty(doneFileName, "doneFileName", this.endpoint);
                DefaultExchange empty = new DefaultExchange(exchange);
                empty.getIn().setBody("");
                this.log.trace("Writing done file: [{}]", (Object)doneFileName);
                if (this.operations.existsFile(doneFileName) && !this.operations.deleteFile(doneFileName)) {
                    throw new GenericFileOperationFailedException("Cannot delete existing done file: " + doneFileName);
                }
                this.writeFile(empty, doneFileName);
            }
            exchange.getIn().setHeader("CamelFileNameProduced", target);
        }
        catch (Exception e) {
            this.handleFailedWrite(exchange, e);
        }
        this.postWriteCheck(exchange);
    }

    private void doMoveExistingFile(String fileName) throws GenericFileOperationFailedException {
        Exchange dummy = this.endpoint.createExchange();
        String parent = FileUtil.onlyPath(fileName);
        String onlyName = FileUtil.stripPath(fileName);
        dummy.getIn().setHeader("CamelFileName", fileName);
        dummy.getIn().setHeader("CamelFileNameOnly", onlyName);
        dummy.getIn().setHeader("CamelFileParent", parent);
        String to = this.endpoint.getMoveExisting().evaluate(dummy, String.class);
        to = FileUtil.normalizePath(to);
        if (ObjectHelper.isEmpty(to)) {
            throw new GenericFileOperationFailedException("moveExisting evaluated as empty String, cannot move existing file: " + fileName);
        }
        boolean renamed = this.operations.renameFile(fileName, to);
        if (!renamed) {
            throw new GenericFileOperationFailedException("Cannot rename file from: " + fileName + " to: " + to);
        }
    }

    public void handleFailedWrite(Exchange exchange, Exception exception) throws Exception {
        throw exception;
    }

    public void preWriteCheck() throws Exception {
    }

    public void postWriteCheck(Exchange exchange) {
    }

    public void writeFile(Exchange exchange, String fileName) throws GenericFileOperationFailedException {
        boolean success;
        if (this.endpoint.isAutoCreate()) {
            String name = FileUtil.normalizePath(fileName);
            File file = new File(name);
            String directory = file.getParent();
            boolean absolute = FileUtil.isAbsolute(file);
            if (directory != null && !this.operations.buildDirectory(directory, absolute)) {
                this.log.debug("Cannot build directory [{}] (could be because of denied permissions)", (Object)directory);
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("About to write [{}] to [{}] from exchange [{}]", new Object[]{fileName, this.getEndpoint(), exchange});
        }
        if (!(success = this.operations.storeFile(fileName, exchange))) {
            throw new GenericFileOperationFailedException("Error writing file [" + fileName + "]");
        }
        this.log.debug("Wrote [{}] to [{}]", (Object)fileName, (Object)this.getEndpoint());
    }

    public String createFileName(Exchange exchange) {
        int pos;
        String name;
        Object overrule = exchange.getIn().getHeader("CamelOverruleFileName");
        Object value = overrule != null ? (overrule instanceof Expression ? overrule : exchange.getContext().getTypeConverter().convertTo(String.class, exchange, overrule)) : exchange.getIn().getHeader("CamelFileName");
        if (overrule != null) {
            exchange.getIn().setHeader("CamelFileName", value);
        }
        if (value != null && value instanceof String && StringHelper.hasStartToken((String)value, "simple")) {
            this.log.warn("Simple expression: {} detected in header: {} of type String. This feature has been removed (see CAMEL-6748).", value, (Object)"CamelFileName");
        }
        Expression expression = this.endpoint.getFileName();
        if (value != null && value instanceof Expression) {
            expression = (Expression)value;
        }
        if (expression != null) {
            this.log.trace("Filename evaluated as expression: {}", (Object)expression);
            name = expression.evaluate(exchange, String.class);
        } else {
            name = exchange.getContext().getTypeConverter().convertTo(String.class, exchange, value);
        }
        if (name != null && this.endpoint.isFlatten() && (pos = Math.max(name.lastIndexOf("/"), name.lastIndexOf("\\"))) != -1) {
            name = name.substring(pos + 1);
        }
        String endpointPath = this.endpoint.getConfiguration().getDirectory();
        String baseDir = "";
        if (endpointPath.length() > 0) {
            boolean trailingSlash;
            baseDir = endpointPath;
            boolean bl = trailingSlash = endpointPath.endsWith("/") || endpointPath.endsWith("\\");
            if (!trailingSlash) {
                baseDir = baseDir + this.getFileSeparator();
            }
        }
        String answer = name != null ? baseDir + name : baseDir + this.endpoint.getGeneratedFileName(exchange.getIn());
        if (this.endpoint.getConfiguration().needToNormalize()) {
            answer = this.normalizePath(answer);
        }
        return answer;
    }

    public String createTempFileName(Exchange exchange, String fileName) {
        String tempName;
        String answer = fileName;
        if (exchange.getIn().getHeader("CamelFileName") == null) {
            exchange.getIn().setHeader("CamelFileName", FileUtil.stripPath(fileName));
            tempName = this.endpoint.getTempFileName().evaluate(exchange, String.class);
            exchange.getIn().removeHeader("CamelFileName");
        } else {
            tempName = this.endpoint.getTempFileName().evaluate(exchange, String.class);
        }
        int pos = Math.max(answer.lastIndexOf("/"), answer.lastIndexOf("\\"));
        if (pos == -1) {
            answer = tempName;
        } else {
            StringBuilder sb = new StringBuilder(answer.substring(0, pos + 1));
            sb.append(tempName);
            answer = sb.toString();
        }
        if (this.endpoint.getConfiguration().needToNormalize()) {
            answer = this.normalizePath(answer);
        }
        answer = FileUtil.compactPath(answer, this.getFileSeparator());
        return answer;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        ServiceHelper.startService(this.locks);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.locks);
        super.doStop();
    }
}

