/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import org.apache.camel.Exchange;
import org.apache.camel.component.jms.JmsQueueEndpoint;
import org.apache.camel.component.jms.QueueBrowseStrategy;
import org.springframework.jms.core.BrowserCallback;
import org.springframework.jms.core.JmsOperations;

public class DefaultQueueBrowseStrategy
implements QueueBrowseStrategy {
    @Override
    public List<Exchange> browse(JmsOperations template, String queue2, final JmsQueueEndpoint endpoint) {
        if (endpoint.getSelector() != null) {
            return template.browseSelected(queue2, endpoint.getSelector(), new BrowserCallback<List<Exchange>>(){

                @Override
                public List<Exchange> doInJms(Session session, QueueBrowser browser) throws JMSException {
                    int size2 = endpoint.getMaximumBrowseSize();
                    if (size2 <= 0) {
                        size2 = Integer.MAX_VALUE;
                    }
                    ArrayList<Exchange> answer = new ArrayList<Exchange>();
                    Enumeration iter = browser.getEnumeration();
                    for (int i = 0; i < size2 && iter.hasMoreElements(); ++i) {
                        Message message = (Message)iter.nextElement();
                        Exchange exchange = endpoint.createExchange(message, session);
                        answer.add(exchange);
                    }
                    return answer;
                }
            });
        }
        return template.browse(queue2, new BrowserCallback<List<Exchange>>(){

            @Override
            public List<Exchange> doInJms(Session session, QueueBrowser browser) throws JMSException {
                int size2 = endpoint.getMaximumBrowseSize();
                if (size2 <= 0) {
                    size2 = Integer.MAX_VALUE;
                }
                ArrayList<Exchange> answer = new ArrayList<Exchange>();
                Enumeration iter = browser.getEnumeration();
                for (int i = 0; i < size2 && iter.hasMoreElements(); ++i) {
                    Message message = (Message)iter.nextElement();
                    Exchange exchange = endpoint.createExchange(message, session);
                    answer.add(exchange);
                }
                return answer;
            }
        });
    }
}

