/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.verifier;

import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.ComponentVerifier;
import org.apache.camel.NoSuchOptionException;
import org.apache.camel.TypeConverter;
import org.apache.camel.impl.verifier.CatalogVerifierCustomizer;
import org.apache.camel.impl.verifier.ResultBuilder;
import org.apache.camel.impl.verifier.ResultErrorBuilder;
import org.apache.camel.runtimecatalog.EndpointValidationResult;
import org.apache.camel.runtimecatalog.RuntimeCamelCatalog;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.EndpointHelper;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.StreamUtils;

public class DefaultComponentVerifier
implements ComponentVerifier {
    private final String defaultScheme;
    private final CamelContext camelContext;

    public DefaultComponentVerifier(String defaultScheme, CamelContext camelContext) {
        this.defaultScheme = defaultScheme;
        this.camelContext = camelContext;
    }

    @Override
    public ComponentVerifier.Result verify(ComponentVerifier.Scope scope, Map<String, Object> parameters) {
        if (this.camelContext == null) {
            return ResultBuilder.withStatusAndScope(ComponentVerifier.Result.Status.ERROR, scope).error(ResultErrorBuilder.withCodeAndDescription(ComponentVerifier.VerificationError.StandardCode.INTERNAL, "Missing camel-context").build()).build();
        }
        if (scope == ComponentVerifier.Scope.PARAMETERS) {
            return this.verifyParameters(parameters);
        }
        if (scope == ComponentVerifier.Scope.CONNECTIVITY) {
            return this.verifyConnectivity(parameters);
        }
        return ResultBuilder.unsupportedScope(scope).build();
    }

    protected ComponentVerifier.Result verifyConnectivity(Map<String, Object> parameters) {
        return ResultBuilder.withStatusAndScope(ComponentVerifier.Result.Status.UNSUPPORTED, ComponentVerifier.Scope.CONNECTIVITY).build();
    }

    protected ComponentVerifier.Result verifyParameters(Map<String, Object> parameters) {
        ResultBuilder builder = ResultBuilder.withStatusAndScope(ComponentVerifier.Result.Status.OK, ComponentVerifier.Scope.PARAMETERS);
        this.verifyParametersAgainstCatalog(builder, parameters);
        return builder.build();
    }

    protected void verifyParametersAgainstCatalog(ResultBuilder builder, Map<String, Object> parameters) {
        this.verifyParametersAgainstCatalog(builder, parameters, new CatalogVerifierCustomizer());
    }

    protected void verifyParametersAgainstCatalog(ResultBuilder builder, Map<String, Object> parameters, CatalogVerifierCustomizer customizer) {
        RuntimeCamelCatalog catalog;
        EndpointValidationResult result;
        String scheme = this.defaultScheme;
        if (parameters.containsKey("scheme")) {
            scheme = parameters.get("scheme").toString();
        }
        if (!(result = (catalog = this.camelContext.getRuntimeCamelCatalog()).validateProperties(scheme, parameters.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.camelContext.getTypeConverter().convertTo(String.class, e.getValue()))))).isSuccess()) {
            if (customizer.isIncludeUnknown()) {
                StreamUtils.stream(result.getUnknown()).map(option -> ResultErrorBuilder.withUnknownOption(option).build()).forEach(builder::error);
            }
            if (customizer.isIncludeRequired()) {
                StreamUtils.stream(result.getRequired()).map(option -> ResultErrorBuilder.withMissingOption(option).build()).forEach(builder::error);
            }
            if (customizer.isIncludeInvalidBoolean()) {
                StreamUtils.stream(result.getInvalidBoolean()).map(entry -> ResultErrorBuilder.withIllegalOption((String)entry.getKey(), (String)entry.getValue()).build()).forEach(builder::error);
            }
            if (customizer.isIncludeInvalidInteger()) {
                StreamUtils.stream(result.getInvalidInteger()).map(entry -> ResultErrorBuilder.withIllegalOption((String)entry.getKey(), (String)entry.getValue()).build()).forEach(builder::error);
            }
            if (customizer.isIncludeInvalidNumber()) {
                StreamUtils.stream(result.getInvalidNumber()).map(entry -> ResultErrorBuilder.withIllegalOption((String)entry.getKey(), (String)entry.getValue()).build()).forEach(builder::error);
            }
            if (customizer.isIncludeInvalidEnum()) {
                StreamUtils.stream(result.getInvalidEnum()).map(entry -> ResultErrorBuilder.withIllegalOption((String)entry.getKey(), (String)entry.getValue()).detail("enum.values", result.getEnumChoices((String)entry.getKey())).build()).forEach(builder::error);
            }
        }
    }

    protected CamelContext getCamelContext() {
        return this.camelContext;
    }

    protected <T> T setProperties(T instance, Map<String, Object> properties) throws Exception {
        if (this.camelContext == null) {
            throw new IllegalStateException("Camel context is null");
        }
        if (!properties.isEmpty()) {
            TypeConverter converter = this.camelContext.getTypeConverter();
            IntrospectionSupport.setProperties(converter, instance, properties);
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                String value;
                if (!(entry.getValue() instanceof String) || !EndpointHelper.isReferenceParameter(value = (String)entry.getValue())) continue;
                IntrospectionSupport.setProperty(this.camelContext, converter, instance, entry.getKey(), null, value, true);
            }
        }
        return instance;
    }

    protected <T> T setProperties(T instance, String prefix, Map<String, Object> properties) throws Exception {
        return this.setProperties(instance, IntrospectionSupport.extractProperties(properties, prefix, false));
    }

    protected <T> Optional<T> getOption(Map<String, Object> parameters, String key, Class<T> type) {
        Object value = parameters.get(key);
        if (value != null) {
            return Optional.ofNullable(CamelContextHelper.convertTo(this.camelContext, type, value));
        }
        return Optional.empty();
    }

    protected <T> T getOption(Map<String, Object> parameters, String key, Class<T> type, Supplier<T> defaultSupplier) {
        return this.getOption(parameters, key, type).orElseGet(defaultSupplier);
    }

    protected <T> T getMandatoryOption(Map<String, Object> parameters, String key, Class<T> type) throws NoSuchOptionException {
        return this.getOption(parameters, key, type).orElseThrow(() -> new NoSuchOptionException(key));
    }
}

