/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.Stack;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.processor.DelegateAsyncProcessor;
import org.apache.camel.processor.ErrorHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FatalFallbackErrorHandler
extends DelegateAsyncProcessor
implements ErrorHandler {
    private static final Logger LOG = LoggerFactory.getLogger(FatalFallbackErrorHandler.class);
    private boolean deadLetterChannel;

    public FatalFallbackErrorHandler(Processor processor) {
        this(processor, false);
    }

    public FatalFallbackErrorHandler(Processor processor, boolean isDeadLetterChannel) {
        super(processor);
        this.deadLetterChannel = isDeadLetterChannel;
    }

    @Override
    public boolean process(final Exchange exchange, final AsyncCallback callback) {
        final String id = ExpressionBuilder.routeIdExpression().evaluate(exchange, String.class);
        Stack<String> fatals = exchange.getProperty("CamelFatalFallbackErrorHandler", null, Stack.class);
        if (fatals == null) {
            fatals = new Stack<String>();
            exchange.setProperty("CamelFatalFallbackErrorHandler", fatals);
        }
        if (fatals.search(id) > -1) {
            LOG.warn("Circular error-handler detected at route: {} - breaking out processing Exchange: {}", (Object)id, (Object)exchange);
            exchange.setProperty("CamelErrorHandlerHandled", false);
            exchange.setProperty("CamelFErrorHandlerCircuitDetected", true);
            callback.done(true);
            return true;
        }
        fatals.push(id);
        boolean sync = this.processor.process(exchange, new AsyncCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void done(boolean doneSync) {
                try {
                    if (exchange.getException() != null) {
                        Throwable previous = exchange.getProperty("CamelExceptionCaught", Throwable.class);
                        if (previous != null && previous == exchange.getException()) {
                            previous = null;
                            if (exchange.getException().getSuppressed().length > 0) {
                                previous = exchange.getException().getSuppressed()[0];
                            }
                        }
                        String msg = "Exception occurred while trying to handle previously thrown exception on exchangeId: " + exchange.getExchangeId() + " using: [" + FatalFallbackErrorHandler.this.processor + "].";
                        if (previous != null) {
                            msg = msg + " The previous and the new exception will be logged in the following.";
                            FatalFallbackErrorHandler.this.log(msg);
                            FatalFallbackErrorHandler.this.log("\\--> Previous exception on exchangeId: " + exchange.getExchangeId(), previous);
                            FatalFallbackErrorHandler.this.log("\\--> New exception on exchangeId: " + exchange.getExchangeId(), exchange.getException());
                        } else {
                            FatalFallbackErrorHandler.this.log(msg);
                            FatalFallbackErrorHandler.this.log("\\--> New exception on exchangeId: " + exchange.getExchangeId(), exchange.getException());
                        }
                        if (previous != null) {
                            Throwable[] suppressed = exchange.getException().getSuppressed();
                            boolean found = false;
                            for (Throwable t : suppressed) {
                                if (t != previous) continue;
                                found = true;
                            }
                            if (!found) {
                                exchange.getException().addSuppressed(previous);
                            }
                        }
                        exchange.setProperty("CamelExceptionCaught", exchange.getException());
                        if (FatalFallbackErrorHandler.this.deadLetterChannel) {
                            exchange.removeProperty("CamelErrorHandlerHandled");
                        } else {
                            exchange.setProperty("CamelErrorHandlerHandled", false);
                        }
                    }
                }
                finally {
                    Stack fatals = exchange.getProperty("CamelFatalFallbackErrorHandler", null, Stack.class);
                    if (fatals != null) {
                        fatals.remove(id);
                    }
                    callback.done(doneSync);
                }
            }
        });
        return sync;
    }

    private void log(String message) {
        this.log(message, null);
    }

    private void log(String message, Throwable t) {
        if (this.deadLetterChannel) {
            if (t != null) {
                LOG.warn(message, t);
            } else {
                LOG.warn(message);
            }
        } else if (t != null) {
            LOG.error(message, t);
        } else {
            LOG.error(message);
        }
    }

    @Override
    public String toString() {
        return "FatalFallbackErrorHandler[" + this.processor + "]";
    }
}

