/*
 * Decompiled with CFR 0.152.
 */
package org.jasypt.spring31.xml.encryption;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.jasypt.encryption.StringEncryptor;
import org.jasypt.properties.EncryptableProperties;
import org.jasypt.util.text.TextEncryptor;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.support.PropertiesLoaderSupport;

public final class EncryptablePropertiesFactoryBean
extends PropertiesLoaderSupport
implements FactoryBean<Object>,
InitializingBean {
    private boolean singleton = true;
    private Properties singletonInstance;
    private Object encryptor = null;

    public final void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    public final boolean isSingleton() {
        return this.singleton;
    }

    public void setEncryptor(Object encryptor) {
        this.encryptor = encryptor;
    }

    public final void afterPropertiesSet() throws IOException {
        if (this.singleton) {
            this.singletonInstance = this.processEncryptable(this.mergeProperties());
        }
    }

    public final Object getObject() throws IOException {
        if (this.singleton) {
            return this.singletonInstance;
        }
        return this.processEncryptable(this.mergeProperties());
    }

    public Class<?> getObjectType() {
        return EncryptableProperties.class;
    }

    private EncryptableProperties processEncryptable(Properties props) {
        if (this.encryptor == null) {
            throw new IllegalArgumentException("\"encryptor\" property in EncryptableProperties definition cannot be null");
        }
        if (this.encryptor instanceof TextEncryptor) {
            EncryptableProperties encryptableProperties = new EncryptableProperties((TextEncryptor)this.encryptor);
            encryptableProperties.putAll((Map)props);
            return encryptableProperties;
        }
        if (this.encryptor instanceof StringEncryptor) {
            EncryptableProperties encryptableProperties = new EncryptableProperties((StringEncryptor)this.encryptor);
            encryptableProperties.putAll((Map)props);
            return encryptableProperties;
        }
        throw new IllegalArgumentException("\"encryptor\" property in EncryptableProperties definition must be either an org.jasypt.util.text.TextEncryptor or an org.jasypt.encryption.StringEncryptor object. An object of class " + this.encryptor.getClass().getName() + " has been specified instead.");
    }
}

