/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jsr356.server.deploy;

import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.HandlesTypes;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.server.ServerApplicationConfig;
import javax.websocket.server.ServerEndpoint;
import javax.websocket.server.ServerEndpointConfig;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.jsr356.server.ServerContainer;
import org.eclipse.jetty.websocket.server.WebSocketUpgradeFilter;

@HandlesTypes(value={ServerApplicationConfig.class, ServerEndpoint.class, Endpoint.class})
public class WebSocketServerContainerInitializer
implements ServletContainerInitializer {
    public static final String ENABLE_KEY = "org.eclipse.jetty.websocket.jsr356";
    private static final Logger LOG = Log.getLogger(WebSocketServerContainerInitializer.class);

    public static ServerContainer configureContext(ServletContextHandler context) throws ServletException {
        WebSocketUpgradeFilter filter = WebSocketUpgradeFilter.configureContext(context);
        ServerContainer jettyContainer = new ServerContainer(filter, filter.getFactory(), context.getServer().getThreadPool());
        context.addBean(jettyContainer);
        context.setAttribute(javax.websocket.server.ServerContainer.class.getName(), jettyContainer);
        return jettyContainer;
    }

    public static ServerContainer configureContext(ServletContext context, ServletContextHandler jettyContext) throws ServletException {
        WebSocketUpgradeFilter filter = WebSocketUpgradeFilter.configureContext(context);
        ServerContainer jettyContainer = new ServerContainer(filter, filter.getFactory(), jettyContext.getServer().getThreadPool());
        jettyContext.addBean(jettyContainer);
        context.setAttribute(javax.websocket.server.ServerContainer.class.getName(), (Object)jettyContainer);
        return jettyContainer;
    }

    private boolean isEnabled(Set<Class<?>> c, ServletContext context) {
        String cp = context.getInitParameter(ENABLE_KEY);
        if (TypeUtil.isTrue(cp)) {
            return true;
        }
        if (TypeUtil.isFalse(cp)) {
            LOG.warn("JSR-356 support disabled via parameter on context {} - {}", context.getContextPath(), context);
            return false;
        }
        Object enable = context.getAttribute(ENABLE_KEY);
        if (TypeUtil.isTrue(enable)) {
            return true;
        }
        if (TypeUtil.isFalse(enable)) {
            LOG.warn("JSR-356 support disabled via attribute on context {} - {}", context.getContextPath(), context);
            return false;
        }
        if (c.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("No JSR-356 annotations or interfaces discovered. JSR-356 support disabled", context.getContextPath(), context);
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onStartup(Set<Class<?>> c, ServletContext context) throws ServletException {
        if (!this.isEnabled(c, context)) {
            return;
        }
        ContextHandler handler = ContextHandler.getContextHandler(context);
        if (handler == null) {
            throw new ServletException("Not running on Jetty, JSR-356 support unavailable");
        }
        if (!(handler instanceof ServletContextHandler)) {
            throw new ServletException("Not running in Jetty ServletContextHandler, JSR-356 support unavailable");
        }
        ServletContextHandler jettyContext = (ServletContextHandler)handler;
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(context.getClassLoader());
            ServerContainer jettyContainer = WebSocketServerContainerInitializer.configureContext(context, jettyContext);
            context.setAttribute(javax.websocket.server.ServerContainer.class.getName(), (Object)jettyContainer);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found {} classes", c.size());
            }
            HashSet<Class<? extends Endpoint>> discoveredExtendedEndpoints = new HashSet<Class<? extends Endpoint>>();
            HashSet discoveredAnnotatedEndpoints = new HashSet();
            HashSet<Class<? extends ServerApplicationConfig>> serverAppConfigs = new HashSet<Class<? extends ServerApplicationConfig>>();
            this.filterClasses(c, discoveredExtendedEndpoints, discoveredAnnotatedEndpoints, serverAppConfigs);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Discovered {} extends Endpoint classes", discoveredExtendedEndpoints.size());
                LOG.debug("Discovered {} @ServerEndpoint classes", discoveredAnnotatedEndpoints.size());
                LOG.debug("Discovered {} ServerApplicationConfig classes", serverAppConfigs.size());
            }
            boolean wasFiltered = false;
            HashSet deployableExtendedEndpointConfigs = new HashSet();
            HashSet deployableAnnotatedEndpoints = new HashSet();
            for (Class clazz : serverAppConfigs) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Found ServerApplicationConfig: {}", clazz);
                }
                try {
                    Set annotatedClasses;
                    ServerApplicationConfig config = (ServerApplicationConfig)clazz.newInstance();
                    Set seconfigs = config.getEndpointConfigs(discoveredExtendedEndpoints);
                    if (seconfigs != null) {
                        wasFiltered = true;
                        deployableExtendedEndpointConfigs.addAll(seconfigs);
                    }
                    if ((annotatedClasses = config.getAnnotatedEndpointClasses(discoveredAnnotatedEndpoints)) == null) continue;
                    wasFiltered = true;
                    deployableAnnotatedEndpoints.addAll(annotatedClasses);
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new ServletException("Unable to instantiate: " + clazz.getName(), (Throwable)e);
                }
            }
            if (!wasFiltered) {
                deployableAnnotatedEndpoints.addAll(discoveredAnnotatedEndpoints);
                deployableExtendedEndpointConfigs = new HashSet();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Deploying {} ServerEndpointConfig(s)", deployableExtendedEndpointConfigs.size());
            }
            for (ServerEndpointConfig serverEndpointConfig : deployableExtendedEndpointConfigs) {
                try {
                    jettyContainer.addEndpoint(serverEndpointConfig);
                }
                catch (DeploymentException e) {
                    throw new ServletException((Throwable)e);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Deploying {} @ServerEndpoint(s)", deployableAnnotatedEndpoints.size());
            }
            for (Class clazz : deployableAnnotatedEndpoints) {
                try {
                    jettyContainer.addEndpoint(clazz);
                }
                catch (DeploymentException e) {
                    throw new ServletException((Throwable)e);
                    return;
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    private void filterClasses(Set<Class<?>> c, Set<Class<? extends Endpoint>> discoveredExtendedEndpoints, Set<Class<?>> discoveredAnnotatedEndpoints, Set<Class<? extends ServerApplicationConfig>> serverAppConfigs) {
        for (Class<?> clazz : c) {
            ServerEndpoint endpoint;
            if (ServerApplicationConfig.class.isAssignableFrom(clazz)) {
                serverAppConfigs.add(clazz);
            }
            if (Endpoint.class.isAssignableFrom(clazz)) {
                discoveredExtendedEndpoints.add(clazz);
            }
            if ((endpoint = clazz.getAnnotation(ServerEndpoint.class)) == null) continue;
            discoveredAnnotatedEndpoints.add(clazz);
        }
    }
}

